/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.model;

import java.util.List;


/**
 * Represents an implementation of a software analyzer (i.e., a profiler).
 */
public interface IAnalyzer {

	/**
	 * Enumeration of possible IAnalyzer features.
	 */
	public static enum Feature {
		TRACE, TIMELINE, CRITICAL_CODE, PERFORMANCE, CALL_TREE, START_STOP, DBG_LOG, DATA_TRACE_IMPORT, IMPORT,

	
		/**
		 * The counterpoints feature has two parts: <li>the analysispoints
		 * support</li> <li>the editor that presents the results</li> <p>This
		 * <code>Feature</code> was created to integrate the results editor in
		 * the framework that presents the other analysis results (this is the
		 * way it is currently used; it is possible to extend/modify its usage
		 * in the future).</p>
		 */
		COUNTERPOINTS,
		/**
		 * Give the user the possibility to rename a set of results.
		 */
		RENAME_RESULTS,
		/**
		 * Disable timestamps if there are covered functions with zero timestamps
		 */
		DISABLE_TIME_IF_COVERED_ZERO_TIME,
		/**
		 * Disable configure coverage results for products not supporting this feature
		 */
		CONFIGURE_RESULTS,
		/**
		 * Gives the possibility to visualize accurate values for timestamps and
		 * metrics while navigating through a partially decoded trace.
		 */
		ACCURATE_VALUES,
		/**
		 * Excludes from profiling statistics symbols or libraries.
		 */
		EXCLUDE_SYMBOLS,
		/**
		 * Provide performance results for metrics. 
		 */
		METRICS_PERFORMANCE
	}
	
	public static enum Supported_Feature_Action {
		/** no special action */
		IS_SUPPORTED,
		/** don't open the view */
		NOT_SUPPORTED,
		/** show a warning window */
		WARN_LIMITED_FUNCTIONALITY
	}


	/**
	 * Check if the contributor supports a specific {@link Feature}.
	 * Implementors should return false for unknown features.
	 * 
	 * @param feature
	 * @return true if the feature is supported, false otherwise.
	 */
	public boolean supports(Feature feature);

	/**
	 * @return the architecture name for the analyzer, e.g., PA for Power Architecture
	 */
	public String getArchName();
	
	/**
	 * @return list of processors or platform types supported by this IAnalyzer, e.g., P4080
	 * @see PlatformType
	 */
	public String[] getProcessors();

	List<Feature> supports();
	
}
