/*******************************************************************************
 * Copyright 2016-2018 NXP
 *
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution.
 *******************************************************************************/
package com.freescale.sa.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

import org.eclipse.debug.core.ILaunchConfiguration;

import com.freescale.sa.SAPlugin;
import com.freescale.sa.util.Utils;

/**
 * class handling core information, to be used in addition to platform type information.
 * 
 * @note Currently not used, added for future support.
 */
public class CoreType {
	
	private final static Map<String, String> coreMap = new HashMap<String, String>();
	private static Properties coreTypeProperties;
    
	private static String SA_CONFIG_DIR_VAR = "CW_SA_CONFIG"; //$NON-NLS-1$
	private static final String DATA_CORES_LOCATION = "/data/fsl.configs.sa.cores"; //$NON-NLS-1$
	
	private synchronized static void loadCoreTypeProperties() {
		if (coreTypeProperties == null) {
			coreTypeProperties = new Properties();
			
			// search in the data/*.platforms directory
			String platformsPathString = System.getenv(SA_CONFIG_DIR_VAR);
			File dir = new File(platformsPathString, DATA_CORES_LOCATION);
			loadCoreTypePropertiesFromFiles(dir.listFiles());
        }
        
	}

	private static void loadCoreTypePropertiesFromFiles(File[] contents) {
		
		if (contents == null) {
			return;
		}
		for (File file : contents) {
			if (!file.isFile()) {
				continue;
			}
			FileInputStream stream = null;
			try {
				stream = new FileInputStream(file);
				coreTypeProperties.load(stream);
			}
			catch (IOException e) {
				SAPlugin.log(e);
				e.printStackTrace();
			} finally {
				if (stream != null) {
					try {
						stream.close();
					} catch (IOException e) {
					}
				}
			}
		}
	}

	static {
		try {
			loadCoreTypeProperties();
			Iterator<Entry<Object, Object> > iter = coreTypeProperties.entrySet().iterator();
			
			while (iter.hasNext()) {
				Entry<Object, Object> entry = iter.next();
				String procName = (String)entry.getKey();
				String coreType = (String)entry.getValue();
				
				coreMap.put(procName, coreType);

			}
		} catch (Exception e) {
			SAPlugin.log(e);
			e.printStackTrace();
		}
	}
	
	/**
	 * Get internal core name.
	 * @Note Internal core name is actually the core type field from debugger DB.
	 * @param processorName Name of processor for which to get internal core name.
	 * @return Internal core name.
	 */
	public static String getInternalCoreName(String processorName) {
		return coreMap.get(processorName);
	}
	

	/**
	 * Get internal core name.
	 * @Note Internal core name is actually the core type field from debugger DB.
	 * @param config Launch configuration for which to get internal core name.
	 * @return Internal core name.
	 */
	public static String getInternalCoreName(ILaunchConfiguration config) {
		String procName = Utils.getProcessorNameFromLaunch(config);
		String coreName = getInternalCoreName(procName);
		
		if (coreName == null){
			// try with launch config core name
			String coreLaunchName = PlatformType.getCoreName(config);
			coreName = coreMap.get(procName + coreLaunchName);		
		}
		
		return coreName;
	}

}
