/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.model;

import java.util.ArrayList;
import java.util.List;

public abstract class BaseAnalyzer implements IAnalyzer {

	@Override
	public List<Feature> supports() {
		List<IAnalyzer.Feature> features = new ArrayList<IAnalyzer.Feature>();
		for (IAnalyzer.Feature feature : IAnalyzer.Feature.values()) {
			if (supports(feature)) {
				features.add(feature);
			}
		}
		return features;
	}

	@Override
	public boolean supports(Feature feature){
		if (feature == Feature.IMPORT)
			return true;
		return false;
	}
}
