/*******************************************************************************
 * Copyright (c) 2014-2016 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa;

/**
 * Place holder for SA constants.
 * 
 * @author B05639
 * 
 */
public class SaConstants {
	public final static int RIGHT_CLICK_BUTTON = 3;
	
	/*Reasonable number of binaries files. */
	public final static int MAX_NO_OF_ELFS = 50;	
	public static final String TRACE_RESULTS_VIEWID = "com.freescale.sa.ui.views.traceresults"; //$NON-NLS-1$
	public static final String EMPTY_STRING = ""; //$NON-NLS-1$
	public static final String DOT_STRING = "."; //$NON-NLS-1$
	/**
	 * The extensions for various result files.
	 */
	// preference attribute indicating whether to prompt for locating a file or
	// editing the path lookup list
	public final static String PREF_DO_NOT_LOCATE_FILE = "pref_sourcebrowser_do_not_locate_file"; //$NON-NLS-1$

	public final static String raw_trace_file_extension = "dat"; //$NON-NLS-1$
	
	/**
	 * The extension of the gems file for collected trace.
	 */
	public final static String raw_gems_file_extension = "gems"; //$NON-NLS-1$

	/**
	 * The extension of the configuration file for decoded trace. This is
	 * currently an archived configuration.
	 */
	public final static String decoded_trace_config_extension = "csv"; //$NON-NLS-1$
	
	
	/**
	 * The extension for executable files
	 */
	public final static String decoded_executable_extension = "elf"; //$NON-NLS-1$

	/**
	 * The extension of the configuration file for raw trace. This is currently
	 * an archived data producer.
	 */
	public final static String raw_trace_config_extension = "resultsConfig"; //$NON-NLS-1$
	
	/**
	 * The template file for results config
	 */
	public final static String template_results_config_file = "/data/fsl.configs.sa.ls.configurators/TEMPLATEResultsLS.resultsConfig"; //$NON-NLS-1$
	
	/**
	 * The extension of the file that contains the metrics description.
	 */
	public final static String metrics_description_extension = "metricsdesc"; //$NON-NLS-1$
	
	
	/**
	 * The extension of the file stored in results folder
	 */
	public final static String storage_flat_profiler_file_extension = "flatprofiler"; //$NON-NLS-1$
	public final static String storage_performance_file_extension = "perf"; //$NON-NLS-1$
	public final static String storage_file_coverage_extension = "fileCov"; //$NON-NLS-1$
	public final static String storage_call_tree_file_extension = "calltree"; //$NON-NLS-1$
	public final static String storage_timeline_file_extension = "timeline"; //$NON-NLS-1$
	public final static String storage_excluded_symbols_file_extension = "sym"; //$NON-NLS-1$
	public final static String storage_decoder_config_file_extension = "xml"; //$NON-NLS-1$
	public final static String storage_raw_fifo_file_extension = "rawTrace"; //$NON-NLS-1$
	public final static String storage_filter_file_extension = "Filter"; //$NON-NLS-1$
	
	
	/** Linux trace archive extensions */
	public static final String USER_SPACE_TRACE_ARCHIVE_EXTENSION = ".cwzsa"; //$NON-NLS-1$
	public static final String KERNEL_SPACE_TRACE_ARCHIVE_EXTENSION = ".kcwzsa"; //$NON-NLS-1$
	public static final String SYSTEM_TRACE_ARCHIVE_EXTENSION = ".scwzsa"; //$NON-NLS-1$
	
	/** Point-to-Point Profiler extensions*/
	public final static String storage_task_instances_report_extension = "kcsv"; //$NON-NLS-1$
	public final static String storage_accelerator_summary_report_extension = "acsv"; //$NON-NLS-1$
	public final static String storage_region_instance_report_extension = "icsv"; //$NON-NLS-1$
	public final static String storage_region_summary_report_extension = "ucsv"; //$NON-NLS-1$
	
	public final static String storage_performance_trace_extension = "aperf"; //$NON-NLS-1$
	public final static String storage_tarmac_trace_extension = "tarmac"; //$NON-NLS-1$
	public final static String storage_gcov_config_extension = "cfg"; //$NON-NLS-1$
	
	public final static String debug_log_file_extension = "dbglog"; //$NON-NLS-1$
	
	/** Sampling profiler extension */
	public final static String storage_sampling_trace_extension = "sample"; //$NON-NLS-1$

	// Storage config.
	/**
	 * The folder where all the trace data are kept.
	 */
	public final static String trace_data_directory = "TraceData"; //$NON-NLS-1$

	/**
	 * The folder where all the analysis results are kept. It has a '.' to hide
	 * it from the user. TODO: improve the mechanism of hiding this folder from
	 * the user.
	 */
	public final static String analysis_results_directory = "/.AnalysisData"; //$NON-NLS-1$

	/**
	 * A folder used to link the SA output folder in the workspace in case it is
	 * located outside the workspace.
	 */
	public final static String analysis_results_directory_link = ".Analysis Data Link"; //$NON-NLS-1$

	// Launch config attributes.

	// @NOTE Kept the "com.freescale.sa.configurator" prefix for backward
	// compatibility

	public static final String ATTR_TRACE_CONTROL_ON_LAUNCH = "com.freescale.sa.configurator" + ".TRACE_CONTROL_ON_LAUNCH"; //$NON-NLS-1$ //$NON-NLS-2$
	public static final String TARGET_CONFIG_TRACE_SCENARIO_ATTR_NAME = "com.freescale.sa.configurator" + ".TRACE_SCENARIO"; //$NON-NLS-1$ //$NON-NLS-2$

	// @NOTE The ENABLE_ANALYSIS attribute is now used by the start/stop feature
	// to set the state of the
	// start/stop button in the case of manual trace config. Its name should
	// change - it's confusing since
	// the attribute lost it's initial purpose.
	public static final String ATTR_ENABLE_ANALYSIS = "com.freescale.sa.configurator" + ".ENABLE_ANALYSIS"; //$NON-NLS-1$ //$NON-NLS-2$
	public static final String ATTR_USE_ALL_CORES= "com.freescale.core.debugger.gdb.USE_ALL_CORES"; //$NON-NLS-1$
	public static final String ATTR_PROGRAM_NAME= "org.eclipse.cdt.launch.PROGRAM_NAME"; //$NON-NLS-1$
	public static final String ATTR_PROJECT_ATTR= "	org.eclipse.cdt.launch.PROJECT_ATTR"; //$NON-NLS-1$
	public static final String ATTR_ENABLE_USER_CODE = "com.freescale.sa.configurator" + ".ENABLE_USER_CODE"; //$NON-NLS-1$ //$NON-NLS-2$
	public static final String ATTR_ENABLE_COLLECT_AUTOMATICALLY= "com.freescale.sa.configurator" + ".ENABLE_COLLECT_AUTOMATICALLY"; //$NON-NLS-1$ //$NON-NLS-2$

    // Gcov and P2P profiler
    public static final String LAUNCH_PLUGIN_ID = "com.freescale.sa.dpaa.launch"; //$NON-NLS-1$
    public static final String ATTR_ENABLE_GCOV_COVERAGE = LAUNCH_PLUGIN_ID + ".ENABLE_GCOV"; //$NON-NLS-1$

    public static final String ATTR_ENABLE_P2PP_PERFORMANCE = LAUNCH_PLUGIN_ID
                                                              + ".ENABLE_PERFORMANCE"; //$NON-NLS-1$

	public static final String ATTR_TARGET_CONTEXT = "com.freescale.core.debugger.gdb.targetContext"; //$NON-NLS-1$
	public static final String ATTR_PROC_NAME = "com.freescale.cdt.debug.cw.core.settings.DebuggerCommonData.Processor Attr Name"; //$NON-NLS-1$
	public static final boolean DEFAULT_ATTR_TRACE_CONTROL_ON_LAUNCH = false;
	
	public static final String DEFAULT_BASE_NAME= "trace"; //$NON-NLS-1$

	public static final String SA_HOME_DIR_VAR = "CW_SA_HOME"; //$NON-NLS-1$
	public static final String SA_CONFIG_DIR_VAR = "CW_SA_CONFIG"; //$NON-NLS-1$

	public static final String LINUX_SATRACE_CONFIG_DIR = "config"; //$NON-NLS-1$
	public static final String LINUX_SATRACE_BIN_DIR = "bin"; //$NON-NLS-1$
	public static final String LINUX_SATRACE_EXECUTABLE = "ls.linux.satrace"; //$NON-NLS-1$
	public static final String LINUX_LS1_SATRACE_CONFIG_FILE = "PlatformConfig.xml"; //$NON-NLS-1$

	/* Debug Print constants */
	public static final String LINUX_LS1_DEBUGPRINT_DIR = "linux.armv7.debugprint"; //$NON-NLS-1$
	public static final String LINUX_LS2_DEBUGPRINT_DIR = "linux.armv8.debugprint"; //$NON-NLS-1$
	public static final String LINUX_APP_DEBUGPRINT_DIR = "linux.app.debugprint"; //$NON-NLS-1$
	public static final String LINUX_LS1_DEBUGPRINT_EXECUTABLE = "ls.target.server"; //$NON-NLS-1$

	// Platform config related constants.
	public static final String PLATFORM_CONFIG_FOLDER = "platformConfig"; //$NON-NLS-1$
	public static final String OUTPUT_CONFIG_FOLDER = "outputConfig"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_EXTENSION = "xml"; //$NON-NLS-1$
	public static final String OUTPUT_CONFIG_EXTENSION = "xml"; //$NON-NLS-1$

	public static final String LAUNCH_CFG_ATTR_PLATFORM_CONFIG = SAPlugin.PLUGIN_ID + ".PLATFORM_CONFIG"; //$NON-NLS-1$
	public static final String DECODER_MANAGER_CONFIG_EXTENSION = "dmConfig"; //$NON-NLS-1$
	
	//Recommendation engine constants.
	public static final String GEMS_DB_EXT = "gems"; //$NON-NLS-1$

    public static final String LAUNCH_ATTR_START_TRACE_ON_LAUNCH = "com.freescale.sa.launch.ui.START_TRACE_ON_LAUNCH"; //$NON-NLS-1$
    
    // Launch config attributes
    public static final String PREFIX = "com.freescale.sa";
    public static final String ATTR_CHANGE_ON_LAUNCH = PREFIX
            + ".CHANGE_ON_LAUNCH"; // $NON-NLS-1$
    public static final String ATTR_TRACE_CONTROL_AUTOMATIC = PREFIX
            + ".TRACE_CONTROL_AUTOMATIC"; // $NON-NLS-1$

}
