/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa;


import java.io.File;
import java.net.URL;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;


/**
 * The activator class controls the plug-in life cycle
 */
public class SAPlugin extends AbstractUIPlugin {
	
	private static Logger LOGGER = Logger.getLogger(SAPlugin.class);

	// The plug-in ID
	public static final String PLUGIN_ID = "com.freescale.sa"; //$NON-NLS-1$
	
	public static final String FILE_MKDIR_ERROR = "Error: could not create directory! ";
	public static final String FILE_DELETE_ERROR = "Error: could not delete file! ";
	public static final String FILE_PROP_ERROR = "Error: could not change file properties! ";

	// The shared instance
	private static SAPlugin plugin;
	
	private static void setPlugin(SAPlugin _plugin) {
		plugin = _plugin;
	}
	
	/**
	 * Status code indicating an unexpected internal error.
	 */
	public static final int INTERNAL_ERROR = 120;	
	
	private File configurationDirectory;

	/**
	 * The constructor
	 */
	public SAPlugin() {}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		setPlugin(this);       
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		setPlugin(null);
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static SAPlugin getDefault() {
		return plugin;
	}
	
	/**
	 * Logs the specified status with this plug-in's log.
	 * 
	 * @param status status to log
	 * @since 2.0
	 */
	public static void log(IStatus status) {
		getDefault().getLog().log(status);
	}
	
	/**
	 * Logs the specified throwable with this plug-in's log.
	 * 
	 * @param t throwable to log 
	 * @since 2.0
	 */
	public static void log(Throwable t) {
		IStatus status = new Status(IStatus.ERROR, getUniqueIdentifier(), INTERNAL_ERROR,
				"Error logged from SA Plugin: ", t); //$NON-NLS-1$

		log(status);
	}
	
	/**
	 * Convenience method which returns the unique identifier of this plug-in.
	 * 
	 * @return debug plug-in identifier
	 */
	public static String getUniqueIdentifier() {
		return PLUGIN_ID;
	}
			
	public File getConfigurationLocation() {
		if (configurationDirectory == null) {
			Location location = Platform.getConfigurationLocation();

			if (location != null) {
				URL configURL = location.getURL();

				if (configURL != null && configURL.getProtocol().startsWith("file")) { //$NON-NLS-1$
					configurationDirectory = new File(
							configURL.getFile(), PLUGIN_ID);
					if (configurationDirectory != null && !configurationDirectory.exists()) {
						if (!configurationDirectory.mkdirs()) {
							LOGGER.warn(FILE_MKDIR_ERROR + configurationDirectory.getName());
						}
					}
				}
			}
		}
		return configurationDirectory;
	}
	
	public static void logMessage(String message) {
		log(new Status(IStatus.ERROR, getUniqueIdentifier(), INTERNAL_ERROR, message, null)); //$NON-NLS-1$
	}
	
	
	public boolean getShowSourceFileLocateDialog() {
		return !getPreferenceStore().getBoolean(SaConstants.PREF_DO_NOT_LOCATE_FILE);
	}
	
	public void setShowSourceFileLocateDialog(boolean show) {
		getPreferenceStore().setValue(SaConstants.PREF_DO_NOT_LOCATE_FILE, !show);
	}
}
