/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa;

import java.util.ArrayList;
import java.util.Collection;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

/**
 * Generic container for extension points. It will load all defined extension
 * points in constructor.
 * 
 * @author b46903
 * 
 * @param <T>
 *            Extension point interface
 */
public abstract class ExtensionContainer<T> {
	private static final Logger LOGGER = Logger
			.getLogger(ExtensionContainer.class);
	protected Collection<T> extensions = new ArrayList<T>();

	private void loadExtensions() {
		IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(
				getExtensionPointName());
		if (ep == null) {
			LOGGER.error("No extensions found for : " + getExtensionPointName()); //$NON-NLS-1$
			return;
		}

		IConfigurationElement[] configs = ep.getConfigurationElements();
		if (configs == null || configs.length == 0) {
			LOGGER.error("No class implementing " + getExtensionPointName() + " extension point."); //$NON-NLS-1$
			return;
		}

		for (IConfigurationElement element : configs) {
			try {
				@SuppressWarnings("unchecked")
				T extension = (T) element.createExecutableExtension("class"); //$NON-NLS-1$
				extensions.add(extension);
			} catch (CoreException e) {
				LOGGER.error("Cannot create extension points " + getExtensionPointName(), e); //$NON-NLS-1$
			}
		}
	}

	protected ExtensionContainer() {
		loadExtensions();
	}

	/**
	 * Returns a string that defines uniquely the extension point.
	 * 
	 * @return
	 */
	protected abstract String getExtensionPointName();
}
