/*****************************************************************************
 *
 * Copyright 2019 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#include "oal.h"
#include "apex.h"

#include "isp_gen.h"
#include "isp_user_define.h"

#include "acf_host.h"

int main(int, char **)
{
  
    /* OAL and APEX initialization */
    OAL_Initialize();

    /* The ACF_APP_CALL is placeholder for APEX application */
    ACF_APP_CALL(); 
     
/**********************************************************************
    The ISP_CALL is placeholder for calling the graph. 
    The definition of ISP_CALL is generated by graph tool to perform 
    all the manipulations with created process. 
    The user can change this code using other methods for process manipulation
    generated by graph tool.
**********************************************************************/

	ISP_CALL();

	return 0;
  
}

 /**********************************************************************
     The io_config is placeholder for calling the initialization of Input/Output.
     io_config is called from the code generated by graph tool.
     The user should add the code to execute all steps to initialize
     DDR buffers.
 **********************************************************************/
void io_config(sdi_grabber *lpGrabber)
{
    /* Insert the code to initialize  DDR buffers */   
}

/**********************************************************************
    The camera_config is placeholder for calling the initialization of camera. 
    camera_config is called from the code generated by graph tool. 
    The user should add the code to execute all steps to initialize 
    the camera installed in his board.
**********************************************************************/
void camera_config()
{
    /* Insert the code to initialize  the camera */ 
}

