/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.acceleo;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

public class JarFileURIConverter
extends ExtensibleURIConverterImpl {
    private static final String LIB_PATH = "lib";

    public URI normalize(URI uri) {
        Map map = this.getURIMap();
        URI resolved = (URI)map.get(uri);
        if (resolved != null) {
            return resolved;
        }
        URI result = JarFileURIConverter.tryToNormalize(uri, LIB_PATH);
        if (result != null) {
            map.put(uri, result);
            return result;
        }
        return super.normalize(uri);
    }

    public static URI tryToNormalize(URI uri, String libPath) {
        if (!uri.isArchive()) {
            return null;
        }
        Path path = JarFileURIConverter.getPath(JarFileURIConverter.getAuthority(uri));
        if (Files.exists(path, new LinkOption[0])) {
            return uri;
        }
        Path jarFile = JarFileURIConverter.findJar(path, libPath);
        String fileURIString = URI.createFileURI((String)jarFile.toAbsolutePath().toString()).toString();
        String uriPath = uri.path();
        if (uriPath != null) {
            return URI.createURI((String)String.format("%s:%s!%s", uri.scheme(), fileURIString, uriPath));
        }
        return URI.createURI((String)String.format("%s:%s", uri.scheme(), fileURIString));
    }

    private static Path getPath(String authority) {
        try {
            return Paths.get(new java.net.URI(authority));
        }
        catch (URISyntaxException e) {
            throw new URIConverterException(e);
        }
    }

    private static Path findJar(Path path, String libPath) {
        String fileName = path.getFileName().toString();
        String baseName = JarFileURIConverter.getBaseName(fileName);
        String extension = JarFileURIConverter.getExtension(fileName);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Stream<Path> stream = Files.find(Paths.get(libPath, new String[0]), 2, (p, a) -> {
                String fn = p.getFileName().toString();
                return fn.startsWith(baseName) && fn.endsWith(extension);
            }, new FileVisitOption[0]);){
                List paths = stream.collect(Collectors.toList());
                if (paths.size() == 0) {
                    throw new URIConverterException("Cannot find bundle for " + path);
                }
                if (paths.size() > 1) {
                    throw new URIConverterException("Exist more than one bundle candidate for " + path.toString() + " : " + paths);
                }
                return (Path)paths.get(0);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new URIConverterException(e);
        }
    }

    private static String getExtension(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i >= 0) {
            return fileName.substring(i);
        }
        return "";
    }

    private static String getBaseName(String fileName) {
        int indexOf = fileName.indexOf(45);
        if (indexOf >= 0) {
            return fileName.substring(0, indexOf + 1);
        }
        return fileName;
    }

    private static String getAuthority(URI uri) {
        String authority = uri.authority();
        if (authority.endsWith("!")) {
            authority = authority.substring(0, authority.length() - 1);
        }
        return authority;
    }

    private static class URIConverterException
    extends RuntimeException {
        public URIConverterException(String message) {
            super(message);
        }

        public URIConverterException(Throwable cause) {
            super(cause);
        }
    }
}

