/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.ecore.external;

import com.nxp.s32ds.ext.emf.internal.ecore.EmfEcoreActivator;
import com.nxp.s32ds.ext.rcp.variables.VariableManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;

public class ExternalUriProtocol {
    public static final String SCHEMA = "s32ds";
    public static final String VARIABLE_PART = "variable";
    public static final String FILE_URI_PREFIX = "file:/";

    public static String getProtocol(String variableId) {
        return String.format("%s/%s", ExternalUriProtocol.getProtocolStaticPart(), variableId);
    }

    public static String getProtocolStaticPart() {
        return String.format("%s://%s", SCHEMA, VARIABLE_PART);
    }

    public static String extractVariableId(URI uri) {
        String strUri = URI.decode((String)uri.toString());
        strUri = strUri.replace(ExternalUriProtocol.getProtocolStaticPart(), "");
        strUri = strUri.replace("/", "\\");
        String[] dividedBySeparator = strUri.trim().split("\\\\");
        ExternalUriProtocol.removeEmpty(dividedBySeparator);
        if (strUri.equals(dividedBySeparator[0])) {
            return uri.toString();
        }
        String retVal = dividedBySeparator[0].replaceAll("#", "");
        return retVal;
    }

    private static String[] removeEmpty(String[] array) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(array));
        list.removeAll(Arrays.asList(""));
        return list.toArray(array);
    }

    public static URI resolve(URI uri) {
        if (SCHEMA.equals(uri.scheme())) {
            String varId = ExternalUriProtocol.extractVariableId(uri);
            String protocolPart = ExternalUriProtocol.getProtocol(varId);
            String pathPart = uri.toString().replace(protocolPart, "");
            try {
                String resolved = VariableManager.INSTANCE.resolve(varId);
                resolved = resolved.concat(pathPart);
                resolved = resolved.replace("\\", "/");
                if (new File(resolved).isAbsolute()) {
                    return URI.createFileURI((String)resolved);
                }
                return URI.createURI((String)resolved);
            }
            catch (CoreException e) {
                EmfEcoreActivator.getInstance().logError(e.getMessage(), e);
                return uri;
            }
        }
        return uri;
    }

    public static URI deresolve(URI uri, String variableId) {
        if (uri.isFile()) {
            String strUri = uri.toFileString();
            try {
                String value = URI.createFileURI((String)VariableManager.INSTANCE.resolve(variableId)).toFileString();
                strUri = strUri.replace(value, ExternalUriProtocol.getProtocol(variableId));
                strUri = ExternalUriProtocol.cleanBegining(strUri);
                strUri = strUri.replace("\\", "/");
                URI newUri = URI.createURI((String)URI.decode((String)strUri));
                return newUri;
            }
            catch (CoreException e) {
                EmfEcoreActivator.getInstance().logError(e.getMessage(), e);
            }
        }
        return uri;
    }

    private static String cleanBegining(String str) {
        int ind = str.indexOf(SCHEMA);
        if (ind > 0) {
            return str.substring(ind);
        }
        return str;
    }
}

