/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.ecore;

import com.nxp.s32ds.ext.emf.ecore.EmfEcore;
import com.nxp.s32ds.ext.emf.ecore.external.ExternalUriProtocol;
import com.nxp.s32ds.ext.emf.internal.ecore.EmfEcoreActivator;
import com.nxp.s32ds.ext.emf.internal.ecore.EmfEcoreMessages;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.util.NLS;

public class EmfResources {
    private static final String EMPTY_EXTENSION = "";
    private static final String archiveUriPrefix = "archive:file:///";
    private static final String fileUriPrefix = "file:///";
    private static final String archiveInternalSeparator = "!/";
    private static final char EXTENSION_SEPARATOR = '.';

    public static final ResourceSet createResourceSet() {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        return rs;
    }

    public static final URI extractURI(String uri) {
        if (uri == null) {
            return null;
        }
        try {
            URI created = URI.createURI((String)uri, (boolean)true);
            return created;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List<URI> extractURIs(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return Collections.emptyList();
        }
        EList resources = resourceSet.getResources();
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        URIConverter converter = resourceSet.getURIConverter();
        for (Resource resource : resources) {
            URI uri = resource.getURI();
            uri = converter.normalize(uri);
            uris.add(uri);
        }
        return uris;
    }

    public static IPath getPath(Resource resource) {
        URI uri = EmfResources.getUri(resource);
        if (uri == null) {
            return null;
        }
        return EmfResources.getPath(uri);
    }

    public static File getFile(Resource resource) {
        URI uri = EmfResources.getUri(resource);
        if (uri == null) {
            return null;
        }
        return EmfResources.getFile(uri);
    }

    public static URI getUri(Resource resource) {
        URIConverter uriConverter;
        if (resource == null) {
            return null;
        }
        URI uri = resource.getURI();
        if (uri == null) {
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet != null && (uriConverter = resourceSet.getURIConverter()) != null) {
            uri = uriConverter.normalize(uri);
        }
        return uri;
    }

    public static URI replaceExtension(URI uri, String newExt) {
        if (uri == null) {
            return null;
        }
        if (uri.isPlatform()) {
            return URI.createPlatformResourceURI((String)EmfResources.replaceExtension(uri.toPlatformString(true), newExt), (boolean)true);
        }
        if (uri.isFile()) {
            return URI.createFileURI((String)EmfResources.replaceExtension(uri.toFileString(), newExt));
        }
        return null;
    }

    public static IPath getPath(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.isPlatform()) {
            return new Path(uri.toPlatformString(true));
        }
        if (uri.isFile()) {
            return new Path(uri.toFileString());
        }
        if ("s32ds".equals(uri.scheme())) {
            URI resolvedUri = ExternalUriProtocol.resolve(uri);
            return new Path(resolvedUri.toFileString());
        }
        return null;
    }

    public static File getFile(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.isFile()) {
            return new File(uri.toFileString());
        }
        return null;
    }

    public static final <E extends EObject> List<E> load(String uri, Class<E> clazz) {
        URI extracted = EmfResources.extractURI(uri);
        return EmfResources.load(extracted, EmfResources.createResourceSet(), clazz);
    }

    public static final <E extends EObject> List<E> load(URI uri, ResourceSet rs, Class<E> clazz) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        List<EObject> loaded = EmfResources.load(uri, rs);
        for (EObject eObject : loaded) {
            Class<?> loadedClass = eObject.getClass();
            if (!clazz.isAssignableFrom(loadedClass)) continue;
            EObject checked = eObject;
            result.add(checked);
        }
        return result;
    }

    public static final List<EObject> load(String uri) {
        URI extracted = EmfResources.extractURI(uri);
        return EmfResources.load(extracted);
    }

    public static final List<EObject> load(URI uri) {
        ResourceSet resourceSet = EmfResources.createResourceSet();
        return EmfResources.load(uri, resourceSet);
    }

    public static final List<EObject> load(URI uri, ResourceSet resourceSet) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (uri != null) {
            ResourceSet rs = resourceSet;
            if (rs == null) {
                rs = EmfResources.createResourceSet();
            }
            Resource resource = rs.getResource(uri, true);
            try {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("ENCODING", StandardCharsets.UTF_8.name());
                resource.load(options);
                EList contents = resource.getContents();
                result.addAll((Collection<EObject>)contents);
            }
            catch (IOException e) {
                String error = NLS.bind((String)EmfEcoreMessages.EmfResources_e_loading_model, (Object)uri);
                EmfEcoreActivator.getInstance().logError(error, e);
            }
        }
        return result;
    }

    public static IStatus savePlatformResource(String platformPath, EObject modelRoot) {
        URI platformURI = URI.createPlatformResourceURI((String)platformPath, (boolean)true);
        return EmfResources.save(platformURI, modelRoot);
    }

    public static IStatus save(URI uri, EObject modelRoot) {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        Resource resource = rs.createResource(uri);
        if (modelRoot != null) {
            resource.getContents().add((Object)modelRoot);
        }
        try {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", StandardCharsets.UTF_8.name());
            resource.save(options);
        }
        catch (IOException e) {
            String error = NLS.bind((String)EmfEcoreMessages.EmfResources_e_saving_model, (Object)uri);
            return EmfEcore.createError(error, e);
        }
        return Status.OK_STATUS;
    }

    public static List<URI> toURIs(List<EObject> objects) {
        ArrayList<URI> extracted = new ArrayList<URI>();
        if (objects != null) {
            for (EObject eObject : objects) {
                URI uri;
                Resource eResource;
                if (eObject == null || (eResource = eObject.eResource()) == null || (uri = eResource.getURI()) == null || extracted.contains(uri)) continue;
                extracted.add(uri);
            }
        }
        return extracted;
    }

    public static String replaceExtension(String name, String extension) {
        int index;
        if (extension == null && name == null) {
            return null;
        }
        if (name == null) {
            return String.valueOf('.') + extension;
        }
        String realExt = EMPTY_EXTENSION;
        if (extension != null) {
            realExt = String.valueOf('.') + extension;
        }
        if ((index = name.lastIndexOf(46)) == -1) {
            return String.valueOf(name) + realExt;
        }
        return String.valueOf(name.substring(0, index)) + realExt;
    }

    public static Collection<URI> getResourcesFromArchive(String archiveDirectoryPath, Pattern archiveNamePattern, Pattern resourceNamePattern) {
        ArrayList<URI> retval = new ArrayList<URI>();
        File files = new File(archiveDirectoryPath);
        if (files.isDirectory()) {
            File[] fileArray = files.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File archive = fileArray[n2];
                boolean matches = archiveNamePattern.matcher(archive.getName()).matches();
                if (matches) {
                    retval.addAll(EmfResources.getResourcesFromArchiveFile(archive, resourceNamePattern));
                }
                ++n2;
            }
        }
        return retval;
    }

    private static Collection<URI> getResourcesFromArchiveFile(File file, Pattern resourceNamePattern) {
        ArrayList<URI> retval = new ArrayList<URI>();
        ZipFile zf = null;
        try {
            try {
                zf = new ZipFile(file);
                Enumeration<? extends ZipEntry> e = zf.entries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = e.nextElement();
                    String fileName = ze.getName();
                    if (!resourceNamePattern.matcher(fileName).matches()) continue;
                    String strURI = archiveUriPrefix + file.getAbsolutePath() + archiveInternalSeparator + fileName;
                    URI uri = URI.createURI((String)strURI);
                    retval.add(uri);
                }
            }
            catch (IOException e) {
                EcorePlugin.INSTANCE.log((Object)e.getLocalizedMessage());
                List<URI> list = Collections.emptyList();
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (IOException iOException) {}
                }
                return list;
            }
        }
        catch (Throwable throwable) {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zf != null) {
            try {
                zf.close();
            }
            catch (IOException iOException) {}
        }
        return retval;
    }

    public static Collection<URI> getAllInternalResources(String folderPath, final Pattern resourceNamePattern) {
        final ArrayList<URI> retval = new ArrayList<URI>();
        File path = new File(folderPath);
        if (path.exists()) {
            SimpleFileVisitor<java.nio.file.Path> visitor = new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                    if (resourceNamePattern.matcher(file.toFile().getName()).matches()) {
                        String strUri = EmfResources.fileUriPrefix.concat(file.toString());
                        URI uri = URI.createURI((String)strUri);
                        retval.add(uri);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(path.toPath(), (FileVisitor<? super java.nio.file.Path>)visitor);
            }
            catch (IOException iOException) {}
        }
        return retval;
    }

    public static boolean compareByAbsolutePath(EObject obj1, EObject obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        Resource eResource1 = obj1.eResource();
        Resource eResource2 = obj2.eResource();
        if (eResource1 == null || eResource2 == null) {
            return false;
        }
        URI uri1 = eResource1.getURI();
        URI uri2 = eResource2.getURI();
        if (uri1 == null || uri2 == null) {
            return false;
        }
        IPath path1 = EmfResources.getPath(uri1);
        IPath path2 = EmfResources.getPath(uri2);
        if (path1 == null || path2 == null) {
            return false;
        }
        String absolutePath1 = path1.toFile().getAbsolutePath();
        String absolutePath2 = path2.toFile().getAbsolutePath();
        if (absolutePath1 == null || absolutePath2 == null) {
            return false;
        }
        return absolutePath1.equals(absolutePath2);
    }
}

