/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.ecore;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class EmfResourceReader {
    public EObject readWithPlainResolving(URI uri, Map<String, Object> packageRegistry) throws IOException {
        return this.read(uri, packageRegistry, new HashMap<String, String>());
    }

    public EObject read(URI uri, Map<String, Object> packageRegistry, Map<String, String> substitutionsMap) throws IOException {
        return this.read(uri, packageRegistry, substitutionsMap, null);
    }

    public EObject read(URI uri, Map<String, Object> packageRegistry, Map<String, String> substitutionsMap, URIConverter converter) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        EPackage.Registry reg = resourceSet.getPackageRegistry();
        reg.putAll(packageRegistry);
        if (converter != null) {
            resourceSet.setURIConverter(converter);
        }
        Resource resource = resourceSet.getResource(uri, true);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", StandardCharsets.UTF_8.name());
        resource.load(options);
        EObject obj = resource.getEObject("/");
        substitutionsMap.forEach((arg_0, arg_1) -> EmfResourceReader.lambda$0((ResourceSet)resourceSet, arg_0, arg_1));
        EcoreUtil.resolveAll((EObject)obj);
        return obj;
    }

    private static void resolveProxyUri(InternalEObject proxy, String path, String substitutionPattern) {
        URI oldUri = proxy.eProxyURI();
        String oldStr = oldUri.toString();
        int idx = oldStr.lastIndexOf(substitutionPattern);
        if (idx == -1) {
            return;
        }
        String newStr = path.concat(oldStr.substring(idx += substitutionPattern.length()));
        newStr = "file:/" + newStr;
        URI newUri = URI.createURI((String)newStr);
        proxy.eSetProxyURI(newUri);
    }

    private static /* synthetic */ void lambda$0(ResourceSet resourceSet, String platformPath, String substitutionPattern) {
        if (platformPath != null && !platformPath.isEmpty()) {
            Map map = EcoreUtil.UnresolvedProxyCrossReferencer.find((ResourceSet)resourceSet);
            map.forEach((k, v) -> {
                InternalEObject proxy = (InternalEObject)k;
                EmfResourceReader.resolveProxyUri(proxy, platformPath, substitutionPattern);
            });
        }
    }
}

