/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.ecore;

import com.nxp.s32ds.ext.emf.ecore.semantic.SemanticElements;
import com.nxp.s32ds.ext.emf.ecore.semantic.SemanticPackageDelegate;
import com.nxp.s32ds.ext.emf.ecore.semantic.versions.Messages;
import com.nxp.s32ds.ext.emf.internal.ecore.EmfEcoreActivator;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.osgi.framework.Version;

public class EmfEcore {
    public static final String CONFIRMATION_STATUS = "com.nxp.s32ds.ext.emf.ecore.semantic.confirmModelConversionHandler";

    public static IStatus createError(String message, Throwable exception) {
        return new Status(4, "com.nxp.s32ds.ext.emf.ecore", message, exception);
    }

    public static EObject getEContainer(Object o) {
        if (o instanceof EObject) {
            EObject eObject = (EObject)o;
            return eObject.eContainer();
        }
        return null;
    }

    public static boolean canLoadModel(EObject eObject) throws CoreException {
        Version modelVersion;
        SemanticPackageDelegate delegate = SemanticElements.resolveSemanticPackageDelegate(eObject);
        if (delegate == null) {
            return false;
        }
        Version currentVersion = delegate.getCurrentVersion();
        if (currentVersion.equals((Object)(modelVersion = delegate.getModelVersion(eObject)))) {
            return true;
        }
        if (currentVersion.compareTo(modelVersion) < 0) {
            RcpStatusHandlers.handleStatus((String)"com.nxp.s32ds.ext.rcp.statushandlers.defaultHandler", (IStatus)EmfEcoreActivator.getInstance().createError(Messages.loadedModelVersionIsNewer), (Object)eObject);
            return false;
        }
        IStatus versionValidationStatus = delegate.validateVersion(eObject);
        if (versionValidationStatus.isOK()) {
            return true;
        }
        if (versionValidationStatus.getSeverity() == 4) {
            RcpStatusHandlers.handleStatus((String)"com.nxp.s32ds.ext.rcp.statushandlers.defaultHandler", (IStatus)versionValidationStatus, (Object)eObject);
            return false;
        }
        IStatus confirmationStatus = (IStatus)RcpStatusHandlers.handleStatus((String)CONFIRMATION_STATUS, (IStatus)EmfEcoreActivator.getInstance().createWarning(versionValidationStatus.getMessage()), (Object)eObject);
        if (confirmationStatus.isOK()) {
            IStatus conversionStatus = delegate.convertModel(eObject);
            if (!conversionStatus.isOK()) {
                RcpStatusHandlers.handleStatus((String)"com.nxp.s32ds.ext.rcp.statushandlers.defaultHandler", (IStatus)conversionStatus, (Object)eObject);
                return false;
            }
            return true;
        }
        return false;
    }
}

