/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.server.ui;

import com.nxp.s32ds.rcp.collateral.server.ui.Activator;
import com.nxp.s32ds.rcp.collateral.server.ui.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CollateralServerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Preferences pref = Platform.getPreferencesService().getRootNode().node("instance").node("com.nxp.s32ds.rcp.collateral.server");
    private Text defaultPortInput;
    private Text minPortInput;
    private Text maxPortInput;
    private ModifyListener modifyListener;

    public CollateralServerPreferencePage() {
        this.modifyListener = e -> this.validate();
    }

    private void validate() {
        String defaultPort = this.defaultPortInput.getText();
        String minPort = this.minPortInput.getText();
        String maxPort = this.maxPortInput.getText();
        Button apply = this.getApplyButton();
        if (apply == null) {
            return;
        }
        if (defaultPort != null) {
            try {
                Integer.parseInt(defaultPort.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.CollateralServerPreferencePage_DefaultPortIsInvalid);
                apply.setEnabled(false);
                this.setValid(false);
                return;
            }
        }
        if (minPort != null) {
            try {
                Integer.parseInt(minPort.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.CollateralServerPreferencePage_MinimalPortRangeIsInvalid);
                apply.setEnabled(false);
                this.setValid(false);
                return;
            }
        }
        if (maxPort != null) {
            try {
                Integer.parseInt(maxPort.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.CollateralServerPreferencePage_MaximalPortRangeIsInvalid);
                apply.setEnabled(false);
                this.setValid(false);
                return;
            }
        }
        this.setErrorMessage(null);
        apply.setEnabled(true);
        this.setValid(true);
    }

    public CollateralServerPreferencePage(String title) {
        super(title);
    }

    public CollateralServerPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "id");
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.createDefaultPortComposite(container);
        this.createPortRangeComposite(container);
        this.initialize();
        return container;
    }

    private void createDefaultPortComposite(Composite container) {
        Composite defaultPortComposite = new Composite(container, 0);
        GridLayout defaultPortLayout = new GridLayout();
        defaultPortLayout.marginHeight = 0;
        defaultPortLayout.marginWidth = 0;
        defaultPortLayout.numColumns = 2;
        defaultPortComposite.setLayout((Layout)defaultPortLayout);
        GridData defaultPorGridData = new GridData(768);
        defaultPortComposite.setLayoutData((Object)defaultPorGridData);
        Label defaultPortLabel = new Label(defaultPortComposite, 0);
        defaultPortLabel.setText(NLS.bind((String)Messages.DefaultPort, null));
        this.defaultPortInput = this.createPortInput(defaultPortComposite, "");
    }

    private void createPortRangeComposite(Composite container) {
        Group portRangeGroup = new Group(container, 0);
        portRangeGroup.setText(NLS.bind((String)Messages.AlternativePortsRange, null));
        GridLayout portRangeGroupLayout = new GridLayout();
        portRangeGroupLayout.numColumns = 3;
        portRangeGroup.setLayout((Layout)portRangeGroupLayout);
        GridData portRangeGroupGridData = new GridData(768);
        portRangeGroup.setLayoutData((Object)portRangeGroupGridData);
        this.minPortInput = this.createPortInput((Composite)portRangeGroup, "");
        Label hyphenLabel = new Label((Composite)portRangeGroup, 0);
        hyphenLabel.setText("\u00ad");
        this.maxPortInput = this.createPortInput((Composite)portRangeGroup, "");
    }

    private Text createPortInput(Composite container, String text) {
        GridData portInputGridData = new GridData();
        portInputGridData.widthHint = 100;
        Text portInput = new Text(container, 2052);
        portInput.setLayoutData((Object)portInputGridData);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Image img = fieldDecoration.getImage();
        final ControlDecoration txtDecorator = new ControlDecoration((Control)portInput, 131200);
        txtDecorator.setImage(img);
        txtDecorator.setDescriptionText(Messages.CollateralServerPreferencePage_NotNullNumericField);
        txtDecorator.hide();
        portInput.setText(text);
        portInput.addModifyListener(this.modifyListener);
        portInput.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
                txtDecorator.hide();
            }
        });
        portInput.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                Text text;
                if (e.widget instanceof Text && (text = (Text)e.widget).getText().isEmpty()) {
                    text.setFocus();
                    txtDecorator.show();
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        return portInput;
    }

    private void initialize() {
        this.defaultPortInput.setText(Integer.toString(this.pref.getInt("port-def", 8087)));
        this.minPortInput.setText(Integer.toString(this.pref.getInt("port-min", 1027)));
        this.maxPortInput.setText(Integer.toString(this.pref.getInt("port-max", 49157)));
    }

    protected void performDefaults() {
        super.performDefaults();
        try {
            if (this.pref != null) {
                this.pref.putInt("port-def", 8087);
                this.pref.putInt("port-min", 1027);
                this.pref.putInt("port-max", 49157);
                this.pref.flush();
            }
        }
        catch (BackingStoreException e) {
            Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.server", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        this.defaultPortInput.setText(Integer.toString(this.pref.getInt("port-def", 8087)));
        this.minPortInput.setText(Integer.toString(this.pref.getInt("port-min", 1027)));
        this.maxPortInput.setText(Integer.toString(this.pref.getInt("port-max", 49157)));
    }

    public boolean performOk() {
        block3: {
            block4: {
                if (this.pref == null) break block3;
                if (this.defaultPortInput.getText() != null && this.minPortInput.getText() != null && this.maxPortInput.getText() != null) break block4;
                return false;
            }
            try {
                this.pref.putInt("port-def", Integer.parseInt(this.defaultPortInput.getText()));
                this.pref.putInt("port-min", Integer.parseInt(this.minPortInput.getText()));
                this.pref.putInt("port-max", Integer.parseInt(this.maxPortInput.getText()));
                this.pref.flush();
                return true;
            }
            catch (BackingStoreException e) {
                Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.server", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return false;
    }
}

