/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class BuilderUtils {
    public static IFile createFile(IPath path, IWorkspaceRoot root, IProgressMonitor monitor) throws CoreException {
        IFile newFile = root.getFileForLocation(path);
        if (newFile == null) {
            newFile = root.getFile(path);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!newFile.isDerived()) {
                newFile.setDerived(true, null);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    public static IPath createDirectory(String dirName, IProject project) throws CoreException {
        IFolder folder = project.getFolder(dirName);
        if (!folder.exists()) {
            IFolder parent;
            IPath parentPath = new Path(dirName).removeLastSegments(1);
            if (!parentPath.isEmpty() && !(parent = project.getFolder(parentPath)).exists()) {
                BuilderUtils.createDirectory(parentPath.toString(), project);
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    folder.refreshLocal(0, null);
                }
                throw e;
            }
            if (!folder.isDerived()) {
                folder.setDerived(true, null);
            }
        }
        return folder.getFullPath();
    }

    public static void save(CharSequence content, IFile file) throws CoreException {
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {}
        byte[] bytes = null;
        if (encoding != null) {
            try {
                bytes = content.toString().getBytes(encoding);
            }
            catch (Exception exception) {}
        } else {
            bytes = content.toString().getBytes();
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        boolean force = true;
        file.setContents((InputStream)stream, force, false, null);
    }
}

