/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AddBuilderRunnable
implements ICoreRunnable {
    private static final String EXT_IDE_RESOURCES = "com.nxp.s32ds.ext.ide.resources";
    private final IProject project;
    private final String builderId;
    private final boolean prepend = true;

    public AddBuilderRunnable(IProject project, String builderId) {
        this.project = project;
        this.builderId = builderId;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        ICommand command;
        ICommand[] commands;
        String message;
        if (this.builderId == null || this.builderId.trim().length() == 0) {
            message = "Unable to add invalid build command";
            this.throwError(message);
        }
        if (this.project == null) {
            message = "Unable to add builder for invalid project";
            this.throwError(message);
        }
        if (!this.project.isAccessible()) {
            String pattern = "Unable to add builder {0} for inaccessible project {1}";
            String message2 = NLS.bind((String)pattern, (Object)this.builderId, (Object)this.project.getName());
            this.throwError(message2);
        }
        IProjectDescription description = this.project.getDescription();
        ICommand[] iCommandArray = commands = description.getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            command = iCommandArray[n2];
            String builderName = command.getBuilderName();
            if (this.builderId.equals(builderName)) {
                return;
            }
            ++n2;
        }
        command = this.createCommand(description, this.builderId);
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 1, commands.length);
        newCommands[0] = command;
        description.setBuildSpec(newCommands);
        this.project.setDescription(description, monitor);
    }

    private ICommand createCommand(IProjectDescription description, String builderName) {
        ICommand command = description.newCommand();
        command.setBuilderName(builderName);
        command.setBuilding(6, true);
        command.setBuilding(9, false);
        command.setBuilding(10, true);
        command.setBuilding(15, true);
        return command;
    }

    private void throwError(String message) throws CoreException {
        Status error = new Status(4, EXT_IDE_RESOURCES, message);
        throw new CoreException((IStatus)error);
    }
}

