/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core;

import java.net.URI;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class MakefileMarkerGenerator
implements IMarkerGenerator {
    private IProject project;

    public MakefileMarkerGenerator(IProject project) {
        this.project = project;
    }

    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, lineNumber, errorDesc, severity, errorVar, null);
        this.addMarker(problemMarkerInfo);
    }

    public void addMarker(ProblemMarkerInfo problemMarkerInfo) {
        String name = "Makefile";
        if (problemMarkerInfo.file != null) {
            name = problemMarkerInfo.file.getName();
        }
        StringBuilder sb = new StringBuilder(name);
        sb.append(':').append(problemMarkerInfo.lineNumber).append(':').append(this.getSeverity(problemMarkerInfo.severity));
        if (problemMarkerInfo.description != null) {
            sb.append(':').append(problemMarkerInfo.description);
        }
        if (problemMarkerInfo.variableName != null) {
            sb.append(':').append(problemMarkerInfo.variableName);
        }
        if (problemMarkerInfo.externalPath != null) {
            sb.append(':').append(problemMarkerInfo.externalPath);
        }
        sb.append('\n');
        try {
            Map attributes;
            IMarker[] markers;
            IResource markerResource = problemMarkerInfo.file;
            if (markerResource == null) {
                markerResource = this.project;
            }
            String externalLocation = null;
            if (problemMarkerInfo.externalPath != null && !problemMarkerInfo.externalPath.isEmpty()) {
                externalLocation = problemMarkerInfo.externalPath.toOSString();
            }
            IMarker[] iMarkerArray = markers = markerResource.findMarkers("com.nxp.s32ds.cle.vpt.acf.problem", true, 1);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                String extloc;
                IMarker m = iMarkerArray[n2];
                int line = m.getAttribute("lineNumber", -1);
                int sev = m.getAttribute("severity", -1);
                String msg = (String)m.getAttribute("message");
                if (line == problemMarkerInfo.lineNumber && sev == this.mapMarkerSeverity(problemMarkerInfo.severity) && msg.equals(problemMarkerInfo.description) && ((extloc = (String)m.getAttribute("problem.externalLocation")) == externalLocation || extloc != null && extloc.equals(externalLocation))) {
                    if (this.project == null || this.project.equals((Object)markerResource.getProject())) {
                        return;
                    }
                    String source = (String)m.getAttribute("sourceId");
                    if (this.project.getName().equals(source)) {
                        return;
                    }
                }
                ++n2;
            }
            String type = problemMarkerInfo.getType();
            if (type == null) {
                type = "com.nxp.s32ds.cle.vpt.acf.problem";
            }
            IMarker marker = markerResource.createMarker(type);
            marker.setAttribute("message", (Object)problemMarkerInfo.description);
            marker.setAttribute("severity", this.mapMarkerSeverity(problemMarkerInfo.severity));
            marker.setAttribute("lineNumber", problemMarkerInfo.lineNumber);
            marker.setAttribute("charStart", problemMarkerInfo.startChar);
            marker.setAttribute("charEnd", problemMarkerInfo.endChar);
            if (problemMarkerInfo.variableName != null) {
                marker.setAttribute("problem.variable", (Object)problemMarkerInfo.variableName);
            }
            if (externalLocation != null) {
                URI uri = URIUtil.toURI((String)externalLocation);
                if (uri.getScheme() != null) {
                    marker.setAttribute("problem.externalLocation", (Object)externalLocation);
                    String locationText = NLS.bind((String)CCorePlugin.getResourceString((String)"ACBuilder.ProblemsView.Location"), (Object)problemMarkerInfo.lineNumber, (Object)externalLocation);
                    marker.setAttribute("location", (Object)locationText);
                }
            } else if (problemMarkerInfo.lineNumber == 0) {
                marker.setAttribute("location", (Object)" ");
            }
            if (this.project != null && !this.project.equals((Object)markerResource.getProject())) {
                marker.setAttribute("sourceId", (Object)this.project.getName());
            }
            if ((attributes = problemMarkerInfo.getAttributes()) != null) {
                for (Map.Entry entry : attributes.entrySet()) {
                    marker.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((IStatus)e.getStatus());
        }
    }

    private int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    public String getSeverity(int severity) {
        if (severity == 3) {
            return new String("Error Build");
        }
        if (severity == 2) {
            return new String("Error resource");
        }
        if (severity == 0) {
            return new String("Warning info");
        }
        if (severity == 1) {
            return new String("Warning");
        }
        return new String("Unknown");
    }
}

