/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core;

import com.nxp.s32ds.ext.cdt.core.MakefileMarkerGenerator;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.BuildRunnerHelper;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class BuilderHelper {
    private static final String PATH = "PATH";
    private static final String MSYS_LOC = "${MSYS_LOC}";
    private static final String S32DS_GCC_TOOLCHAIN_DIR = "${S32DS_GCC_TOOLCHAIN_DIR}";
    private static final String MAKE = "make";
    private static final String ALL = "all";
    private static final int PROGRESS_MONITOR_SCALE = 100;
    private static final String EMPTY_STRING = new String();
    private static final String WHITESPACE = " ";

    public static void invokeMake(IProject project, int kind, IProgressMonitor monitor, URI workingDirectoryURI) throws CoreException {
        int state;
        BuildRunnerHelper buildRunnerHelper;
        block12: {
            buildRunnerHelper = new BuildRunnerHelper(project);
            IConsole console = CCorePlugin.getDefault().getConsole();
            console.start(project);
            CommandLauncher launcher = new CommandLauncher();
            IPath buildCommand = BuilderHelper.getBuildCommand();
            String[] commandArguments = BuilderHelper.getCommandArguments();
            HashMap<String, String> envMap = null;
            envMap = BuilderHelper.getEnvironment((ICommandLauncher)launcher, project);
            String[] envp = BuildRunnerHelper.envMapToEnvp(envMap);
            buildRunnerHelper.setLaunchParameters((ICommandLauncher)launcher, buildCommand, commandArguments, workingDirectoryURI, envp);
            String[] errorParsers = BuilderHelper.getErrorParsers(project);
            ErrorParserManager epm = new ErrorParserManager(project, workingDirectoryURI, (IMarkerGenerator)new MakefileMarkerGenerator(project), errorParsers);
            buildRunnerHelper.prepareStreams(epm, null, console, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
            BuilderHelper.removeOldMarkers(project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
            buildRunnerHelper.greeting(kind);
            state = 0;
            try {
                try {
                    state = buildRunnerHelper.build((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
                }
                catch (IOException e) {
                    BuilderHelper.error(e);
                    try {
                        buildRunnerHelper.close();
                    }
                    catch (IOException e2) {
                        BuilderHelper.error(e2);
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    buildRunnerHelper.close();
                }
                catch (IOException e) {
                    BuilderHelper.error(e);
                }
                throw throwable;
            }
            try {
                buildRunnerHelper.close();
            }
            catch (IOException e) {
                BuilderHelper.error(e);
            }
        }
        buildRunnerHelper.goodbye();
        if (state != -1 && buildRunnerHelper != null) {
            buildRunnerHelper.refreshProject(null, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
        }
    }

    private static void error(IOException e) throws CoreException {
        Status error = new Status(4, "com.nxp.s32ds.cle.vpt.acf.core", "Failed to run ACF builder", (Throwable)e);
        throw new CoreException((IStatus)error);
    }

    public static void removeOldMarkers(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", -1);
            if (project != null) {
                monitor.subTask(CCorePlugin.getFormattedString((String)"BuildRunnerHelper.removingMarkers", (String)project.getFullPath().toString()));
                project.deleteMarkers("com.nxp.s32ds.cle.vpt.acf.problem", false, 2);
            }
            if (project != null) {
                IWorkspace workspace = project.getWorkspace();
                IMarker[] markers = workspace.getRoot().findMarkers("com.nxp.s32ds.cle.vpt.acf.problem", true, 2);
                String projectName = project.getName();
                ArrayList<IMarker> markersList = new ArrayList<IMarker>();
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker iter = iMarkerArray[n2];
                    if (projectName.equals(iter.getAttribute("sourceId"))) {
                        markersList.add(iter);
                    }
                    ++n2;
                }
                if (markersList.size() > 0) {
                    workspace.deleteMarkers(markersList.toArray(new IMarker[markersList.size()]));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IPath getBuildCommand() {
        return new Path(MAKE);
    }

    private static String[] getCommandArguments() {
        return new String[]{ALL};
    }

    private static String[] getErrorParsers(IProject project) {
        IManagedBuildInfo buliderInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buliderInfo == null) {
            return null;
        }
        return buliderInfo.getDefaultConfiguration().getErrorParserList();
    }

    private static HashMap<String, String> getEnvironment(ICommandLauncher launcher, IProject project) throws CoreException {
        HashMap<String, String> envMap = new HashMap<String, String>();
        Properties env = launcher.getEnvironment();
        String key = (String)env.keySet().stream().filter(s -> s.equalsIgnoreCase(PATH)).collect(Collectors.toList()).get(0);
        String envPath = (String)env.get(key);
        String makeDir = BuilderHelper.getVariableValue(MSYS_LOC, project);
        String gccDir = BuilderHelper.getVariableValue(S32DS_GCC_TOOLCHAIN_DIR, project);
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf(makeDir) + File.pathSeparator + gccDir + File.pathSeparator + envPath);
        env.put(key, builder.toString());
        envMap.putAll(env);
        return envMap;
    }

    public static String getVariableValue(String variable, IProject project) throws CoreException {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration defaultConfiguration = buildInfo.getDefaultConfiguration();
        String vsdkPath = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(variable, EMPTY_STRING, WHITESPACE, 3, (Object)defaultConfiguration);
        return vsdkPath.replace("\\", "/");
    }
}

