/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.vpt.acf.internal.core;

import com.nxp.s32ds.cle.vpt.acf.ACFMakefileGenerator;
import com.nxp.s32ds.cle.vpt.acf.ACFProjectContext;
import com.nxp.s32ds.cle.vpt.acf.IACFProjectContext;
import com.nxp.s32ds.ext.cdt.core.BuilderHelper;
import com.nxp.s32ds.ext.ide.resources.BuilderUtils;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

public class ACFProjectBuilder
extends IncrementalProjectBuilder {
    private static final int PROGRESS_MONITOR_SCALE = 100;
    private static final int TICKS_STREAM_PROGRESS_MONITOR = 100;
    private static final int TICKS_DELETE_MARKERS = 100;
    private static final int TICKS_EXECUTE_COMMAND = 100;
    private static final String INVOKING_ACF_BUILDER = "Invoking ACF Builder";
    private static final String MAKEFILE = "makefile";
    private static final String VSDK = "${S32DS_VSDK_DIR}";
    private static final String SEPARATOR = "/";
    private IACFProjectContext context;
    private IProject project;

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        this.context = ACFProjectContext.getACFProjectContext();
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        boolean bPerformBuild = true;
        if (kind == 9) {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta != null) {
                IResource res = delta.getResource();
                if (res != null) {
                    bPerformBuild = res.getProject().equals((Object)this.getProject());
                }
            } else {
                bPerformBuild = false;
            }
        }
        if (bPerformBuild) {
            try {
                this.project = this.getProject();
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(INVOKING_ACF_BUILDER + this.project.getName(), 300);
                this.generateMakefile(args, monitor);
                URI buildDirectoryURI = this.getBuildDirectoryURI();
                BuilderHelper.invokeMake(this.project, kind, monitor, buildDirectoryURI);
            }
            finally {
                monitor.done();
            }
        }
        this.checkCancel(monitor);
        return this.getProject().getReferencedProjects();
    }

    private void generateMakefile(Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        BuilderUtils.createDirectory(this.context.getACFObjetDirectoryName(), this.project);
        Path makefilePath = new Path(String.valueOf(this.project.getLocation().toString()) + SEPARATOR + this.context.getACFOutputDirectoryName() + SEPARATOR + MAKEFILE);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile makefile = BuilderUtils.createFile((IPath)makefilePath, root, monitor);
        HashMap variables = new HashMap();
        String graphsSrcDir = this.context.getGraphsDirectoryName();
        String acfDir = this.context.getACFDirectoryName();
        String vsdkDir = BuilderHelper.getVariableValue(VSDK, this.project);
        String acfMask = this.context.getACFSourceSignature();
        CharSequence builder = ACFMakefileGenerator.populateMakefile(variables, (String)graphsSrcDir, (String)acfDir, (String)vsdkDir, (String)acfMask);
        BuilderUtils.save(builder, makefile);
    }

    private URI getBuildDirectoryURI() {
        IPath pathToWorkingDirectory = this.project.getLocation().append(this.context.getACFOutputDirectoryName());
        URI workingDirectoryURI = URIUtil.toURI((IPath)pathToWorkingDirectory);
        return workingDirectoryURI;
    }

    private void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

