/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.clt.acceleo;

import com.nxp.s32ds.ext.emf.clt.CltEmfControlFlowListener;
import com.nxp.s32ds.ext.emf.clt.CltEmfRunner;
import com.nxp.s32ds.ext.emf.clt.acceleo.CltAcceleoControlFlowListener;
import com.nxp.s32ds.ext.emf.clt.acceleo.CltAcceleoProcessor;
import com.nxp.s32ds.ext.orbit.cli.CliOption;
import com.nxp.s32ds.ext.orbit.cli.CliParsedOptions;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CltAcceleoRunner<T extends CltAcceleoProcessor>
extends CltEmfRunner<T> {
    private static final CliOption OUTPUT_DIR_OPTION = CLI.cliOptionBuilder().hasArgs(1).withArgName("path").isRequired(true).withDescription("the output directory").create("outputdir");
    private static final CliOption PROPERTIES_FILE_PATH_OPTION = CLI.cliOptionBuilder().hasArgs(1).withArgName("path").withDescription("the pat to properties file").create("propertiesfile");
    private static final CliOption PROPERTY_OPTION = CLI.cliOptionBuilder().hasArgs(2).withValueSeparator('=').withArgName("property=value").withDescription("use value for given property").create("P");

    public CltAcceleoRunner(Class<T> processorClass) {
        super(processorClass);
    }

    protected String getName() {
        return "CltAcceleoRunner";
    }

    protected Set<CliOption> getOptions() {
        Set options = super.getOptions();
        options.add(OUTPUT_DIR_OPTION);
        options.add(PROPERTIES_FILE_PATH_OPTION);
        options.add(PROPERTY_OPTION);
        return options;
    }

    protected T createProcessor(CliParsedOptions cliParsedOptions, Class<T> processorClass) throws Exception {
        Constructor<T> declaredConstructor = processorClass.getDeclaredConstructor(File.class, List.class, Map.class, String.class);
        File outputDir = Paths.get(cliParsedOptions.getOptionValue("outputdir"), new String[0]).toFile();
        List<Object> processorArguments = this.getProcessorArguments(cliParsedOptions);
        Map properties = cliParsedOptions.getOptionMap("P");
        String propertiesFile = cliParsedOptions.getOptionValue("propertiesfile");
        return (T)((Object)((CltAcceleoProcessor)((Object)declaredConstructor.newInstance(outputDir, processorArguments, properties, propertiesFile))));
    }

    protected List<? extends Object> getProcessorArguments(CliParsedOptions cliParsedOptions) {
        return null;
    }

    protected CltEmfControlFlowListener<T> createControlFlowListener() {
        return new CltAcceleoControlFlowListener();
    }
}

