/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.staticsequencer.core.ast;

import com.nxp.s32ds.mdt.icf.staticsequencer.core.GraphNode;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstExpression;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstVariable;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.LiteralExpression;
import java.util.function.Function;

public class NodeVariable
implements AstVariable {
    private static final Function<String, String> BEAT_DIV_NAME_FUNCTION = new SuffixFunction("_BEAT_DIV");
    private static final Function<String, String> START_NAME_FUNCTION = new SuffixFunction("_START");
    private static final Function<GraphNode, String> BEAT_DIV_NODE_FUNCTION = new NameFunction(BEAT_DIV_NAME_FUNCTION);
    private static final Function<GraphNode, String> START_NODE_FUNCTION = new NameFunction(START_NAME_FUNCTION);
    private final String name;
    private final AstExpression expression;

    public static AstVariable createBeatDiv(GraphNode node, AstExpression expression) {
        return new NodeVariable(BEAT_DIV_NODE_FUNCTION.apply(node), expression);
    }

    public static AstVariable createBeatDiv(GraphNode node, int value) {
        return new NodeVariable(BEAT_DIV_NODE_FUNCTION.apply(node), new LiteralExpression(value));
    }

    public static AstVariable createBeatDiv(String name, int value) {
        return new NodeVariable(BEAT_DIV_NAME_FUNCTION.apply(name), new LiteralExpression(value));
    }

    public static AstVariable createStart(GraphNode node, AstExpression expression) {
        return new NodeVariable(START_NODE_FUNCTION.apply(node), expression);
    }

    public static AstVariable createStart(GraphNode node, int value) {
        return new NodeVariable(START_NODE_FUNCTION.apply(node), new LiteralExpression(value));
    }

    public NodeVariable(String name, AstExpression expression) {
        this.name = name;
        this.expression = expression;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AstExpression getExpression() {
        return this.expression;
    }

    @Override
    public AstVariable resolve() {
        return this;
    }

    public String toString() {
        return "NodeVariable(" + this.name + ", " + this.expression + ")";
    }

    private static class NameFunction
    implements Function<GraphNode, String> {
        private Function<String, String> function;

        NameFunction(Function<String, String> function) {
            this.function = function;
        }

        @Override
        public String apply(GraphNode node) {
            return this.function.apply(node.getName());
        }
    }

    private static class SuffixFunction
    implements Function<String, String> {
        private final String suffix;

        SuffixFunction(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public String apply(String name) {
            return String.valueOf(name.toUpperCase()) + this.suffix;
        }
    }
}

