/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.staticsequencer.core.ast;

import com.nxp.s32ds.mdt.icf.staticsequencer.core.GraphNode;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstExpression;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstVariable;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.CachedVariable;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.Functions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;

public class MaxParentVariable
extends CachedVariable {
    private GraphNode node;
    private Function<GraphNode, AstVariable> function;

    public static AstVariable createBeatDiv(GraphNode node) {
        return new MaxParentVariable(node, Functions.BEAT_DIV);
    }

    public static AstVariable createStart(GraphNode node) {
        return new MaxParentVariable(node, Functions.START);
    }

    public MaxParentVariable(GraphNode node, Function<GraphNode, AstVariable> function) {
        this.node = node;
        this.function = function;
    }

    @Override
    public String getName() {
        return this.resolve().getName();
    }

    @Override
    public AstExpression getExpression() {
        return this.resolve().getExpression();
    }

    @Override
    public AstVariable resolveInternal() {
        ArrayList<AstVariable> variables = new ArrayList<AstVariable>();
        for (GraphNode parent : this.node.getParents()) {
            variables.add(this.function.apply(parent));
        }
        Collections.sort(variables, (v1, v2) -> v1.getExpression().getValue() - v2.getExpression().getValue());
        return (AstVariable)variables.get(variables.size() - 1);
    }

    public String toString() {
        return "MaxParentVariable(" + this.node.getName() + "->" + this.function + ")";
    }
}

