/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.staticsequencer.core.ast;

import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstExpression;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstVariable;
import java.util.ArrayList;
import java.util.Collection;

public class BinaryExpression
implements AstExpression {
    private final AstExpression left;
    private final AstExpression right;
    private final Operator operator;

    public static AstExpression add(AstExpression left, AstExpression right) {
        return new BinaryExpression(left, right, Operator.ADD_OPERATOR);
    }

    public static AstExpression subt(AstExpression left, AstExpression right) {
        return new BinaryExpression(left, right, Operator.SUBT_OPERATOR);
    }

    public static AstExpression mult(AstExpression left, AstExpression right) {
        return new BinaryExpression(left, right, Operator.MULT_OPERATOR);
    }

    public static AstExpression div(AstExpression left, AstExpression right) {
        return new BinaryExpression(left, right, Operator.DIV_OPERATOR);
    }

    public BinaryExpression(AstExpression left, AstExpression right, Operator operator) {
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    @Override
    public int getValue() {
        return this.operator.eval(this.left.getValue(), this.right.getValue());
    }

    @Override
    public String getDefinition() {
        String definition = String.valueOf(this.left.getDefinition()) + " " + this.operator.getToken() + " " + this.right.getDefinition();
        if (this.operator.isParenthesesRequired()) {
            return "(" + definition + ")";
        }
        return definition;
    }

    public String toString() {
        return "BinaryExpression(" + this.getDefinition() + ")";
    }

    @Override
    public Collection<AstVariable> getReferencedVariables() {
        ArrayList<AstVariable> variables = new ArrayList<AstVariable>();
        variables.addAll(this.left.getReferencedVariables());
        variables.addAll(this.right.getReferencedVariables());
        return variables;
    }

    static interface Operator {
        public static final Operator ADD_OPERATOR = new Operator(){

            @Override
            public String getToken() {
                return "+";
            }

            @Override
            public int eval(int left, int right) {
                return left + right;
            }

            @Override
            public boolean isParenthesesRequired() {
                return true;
            }
        };
        public static final Operator SUBT_OPERATOR = new Operator(){

            @Override
            public String getToken() {
                return "-";
            }

            @Override
            public int eval(int left, int right) {
                return left - right;
            }

            @Override
            public boolean isParenthesesRequired() {
                return true;
            }
        };
        public static final Operator MULT_OPERATOR = new Operator(){

            @Override
            public String getToken() {
                return "*";
            }

            @Override
            public int eval(int left, int right) {
                return left * right;
            }

            @Override
            public boolean isParenthesesRequired() {
                return false;
            }
        };
        public static final Operator DIV_OPERATOR = new Operator(){

            @Override
            public String getToken() {
                return "/";
            }

            @Override
            public int eval(int left, int right) {
                return left / right;
            }

            @Override
            public boolean isParenthesesRequired() {
                return false;
            }
        };

        public int eval(int var1, int var2);

        public String getToken();

        public boolean isParenthesesRequired();
    }
}

