/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.staticsequencer.core;

import com.nxp.s32ds.mdt.icf.staticsequencer.core.GraphNode;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.RootGraphNode;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class SequencerNodes {
    public List<GraphNode> getChildren(RootGraphNode rootGraphNode, GraphNode node) {
        ArrayList<GraphNode> result = new ArrayList<GraphNode>();
        Collection<GraphNode> nodes = rootGraphNode.getNodes();
        for (GraphNode graphNode : nodes) {
            List<GraphNode> parents;
            if (this.isHidden(graphNode) || !(parents = this.getParents(graphNode)).contains(node)) continue;
            result.add(graphNode);
        }
        return result;
    }

    public List<GraphNode> getParents(GraphNode node) {
        ArrayList<GraphNode> result = new ArrayList<GraphNode>();
        for (GraphNode parent : node.getParents()) {
            if (this.isHidden(parent)) {
                result.addAll(this.getParents(parent));
                continue;
            }
            result.add(parent);
        }
        return result;
    }

    public Collection<GraphNode> getOrderedNodes(RootGraphNode root) {
        Predicate<GraphNode> predicate = this.needInitialization(root) ? n -> true : n -> n != root;
        return this.getAllOrderedNodes(root).stream().filter(predicate).collect(Collectors.toList());
    }

    private Collection<GraphNode> getAllOrderedNodes(RootGraphNode root) {
        List<GraphNode> list = root.getNodes().stream().filter(n -> !this.isHidden((GraphNode)n)).collect(Collectors.toList());
        Collections.sort(list, (n1, n2) -> {
            int i = n1.getStart().getExpression().getValue() - n2.getStart().getExpression().getValue();
            if (i != 0) {
                return i;
            }
            return n1.id - n2.id;
        });
        return list;
    }

    public Collection<AstVariable> getBeatDivs(RootGraphNode root) {
        Collection<AstVariable> starts = this.getStarts(root);
        LinkedHashSet<AstVariable> dependent = new LinkedHashSet<AstVariable>(this.getReferencedVariables(starts));
        dependent.removeAll(starts);
        LinkedHashSet allNodesBeatDivs = this.getOrderedNodes(root).stream().map(n -> n.getBeatDiv().resolve()).collect(Collectors.toCollection(LinkedHashSet::new));
        dependent.addAll(allNodesBeatDivs);
        return dependent;
    }

    private Set<AstVariable> getReferencedVariables(Collection<AstVariable> variables) {
        LinkedHashSet<AstVariable> result = new LinkedHashSet<AstVariable>();
        for (AstVariable variable : variables) {
            Set referencedVariables = variable.getExpression().getReferencedVariables().stream().map(v -> v.resolve()).collect(Collectors.toCollection(LinkedHashSet::new));
            result.addAll(this.getReferencedVariables(referencedVariables));
            result.addAll(referencedVariables);
        }
        return result;
    }

    public Collection<AstVariable> getStarts(RootGraphNode root) {
        return this.getAllOrderedNodes(root).stream().map(n -> n.getStart().resolve()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected abstract boolean isHidden(GraphNode var1);

    protected abstract boolean needInitialization(GraphNode var1);
}

