/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.staticsequencer.core;

import com.nxp.s32ds.mdt.icf.staticsequencer.api.Expression;
import com.nxp.s32ds.mdt.icf.staticsequencer.api.Node;
import com.nxp.s32ds.mdt.icf.staticsequencer.api.Root;
import com.nxp.s32ds.mdt.icf.staticsequencer.api.Variable;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.GraphNode;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.RootGraphNode;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.SequencerGraphBuilder;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.SequencerNodes;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.SequencerSupport;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstExpression;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstVariable;
import com.nxp.s32ds.mdt.icf.staticsequencer.meta.StaticsequencerFactory;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;

public class SequencerModelBuilder {
    public static Root build(EObject heartBeat, SequencerSupport sequencerSupport) {
        RootGraphNode rootGraphNode = new SequencerGraphBuilder(heartBeat, sequencerSupport).build();
        Root root = StaticsequencerFactory.eINSTANCE.createRoot();
        String errorMessage = rootGraphNode.getErrorMessage();
        if (errorMessage != null) {
            root.setErrorMessage(errorMessage);
            return root;
        }
        root.setElement(rootGraphNode.element);
        SequencerNodes nodes = sequencerSupport.getSequencerNodes();
        Collection<AstVariable> starts = nodes.getStarts(rootGraphNode);
        for (AstVariable astVariable : starts) {
            root.getStarts().add((Object)SequencerModelBuilder.convert(astVariable));
        }
        Collection<AstVariable> beatDivs = nodes.getBeatDivs(rootGraphNode);
        for (AstVariable astVariable : beatDivs) {
            root.getBeatDivs().add((Object)SequencerModelBuilder.convert(astVariable));
        }
        Collection<GraphNode> orderedNodes = nodes.getOrderedNodes(rootGraphNode);
        for (GraphNode graphNode : orderedNodes) {
            root.getNodes().add((Object)SequencerModelBuilder.convert(rootGraphNode, graphNode));
        }
        return root;
    }

    private static Node convert(RootGraphNode rootGraphNode, GraphNode graphNode) {
        Node node = StaticsequencerFactory.eINSTANCE.createNode();
        node.setElement(graphNode.element);
        node.setBeatDiv(SequencerModelBuilder.convert(graphNode.getBeatDiv()));
        node.setStart(SequencerModelBuilder.convert(graphNode.getStart()));
        return node;
    }

    private static Variable convert(AstVariable astVariable) {
        Variable variable = StaticsequencerFactory.eINSTANCE.createVariable();
        variable.setName(astVariable.getName());
        Expression expression = StaticsequencerFactory.eINSTANCE.createExpression();
        AstExpression astExpression = astVariable.getExpression();
        expression.setDefinition(astExpression.getDefinition());
        expression.setValue(astExpression.getValue());
        variable.setExpression(expression);
        return variable;
    }
}

