/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.staticsequencer.core;

import com.nxp.s32ds.mdt.icf.staticsequencer.core.GraphNode;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.RootGraphNode;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.SequencerSupport;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstVariable;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.NodeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;

public class SequencerGraphBuilder {
    private final EObject root;
    private final SequencerSupport sequencerSupport;
    private int counter = 0;

    public static RootGraphNode buildGraphSequencer(EObject heartBeat, SequencerSupport sequencerSupport) {
        if (heartBeat == null) {
            throw new IllegalArgumentException("Argument heartBeat is null.");
        }
        return new SequencerGraphBuilder(heartBeat, sequencerSupport).build();
    }

    public SequencerGraphBuilder(EObject root, SequencerSupport sequencerSupport) {
        this.root = root;
        this.sequencerSupport = sequencerSupport;
    }

    public RootGraphNode build() {
        try {
            HashMap<EObject, GraphNode> map = new HashMap<EObject, GraphNode>();
            RootGraphNode rootGraphNode = new RootGraphNode(this.counter++, this.root, map, this.sequencerSupport.getNameFunction());
            map.put(this.root, rootGraphNode);
            ArrayList<GraphNode> list = new ArrayList<GraphNode>();
            list.add(rootGraphNode);
            this.buildGraph(list, map);
            this.setupStaticData(rootGraphNode);
            return rootGraphNode;
        }
        catch (Exception e) {
            return new RootGraphNode(e.getMessage());
        }
    }

    public static String getStructure(RootGraphNode rootGraphNode) {
        String prefix = "";
        StringBuilder builder = new StringBuilder();
        SequencerGraphBuilder.printStructure(builder, prefix, rootGraphNode.getNodes(), rootGraphNode);
        return builder.toString();
    }

    private static void printStructure(StringBuilder builder, String prefix, Collection<GraphNode> nodes, GraphNode graphNode) {
        builder.append(prefix).append(graphNode.getName()).append(":").append("\n");
        builder.append(prefix).append("\tbeatDiv=").append(graphNode.getBeatDiv()).append("\n");
        builder.append(prefix).append("\tstart=").append(graphNode.getStart()).append("\n");
        for (GraphNode node : nodes) {
            if (!node.getParents().contains(graphNode)) continue;
            SequencerGraphBuilder.printStructure(builder, String.valueOf(prefix) + "\t", nodes, node);
        }
    }

    private void setupStaticData(RootGraphNode rootGraphNode) {
        Switch<AstVariable> beatDivSwitch = this.sequencerSupport.getBeatDivSwitch(rootGraphNode);
        Switch<AstVariable> rootDivSwitch = this.sequencerSupport.getRootBeatDivSwitch(rootGraphNode);
        Switch<AstVariable> startSwitch = this.sequencerSupport.getStartSwitch(rootGraphNode);
        for (GraphNode graphNode : rootGraphNode.getNodes()) {
            EObject element = graphNode.element;
            if (graphNode instanceof RootGraphNode) {
                graphNode.setBeatDiv((AstVariable)rootDivSwitch.doSwitch(element));
                graphNode.setStart(NodeVariable.createStart((GraphNode)rootGraphNode, 0));
                continue;
            }
            graphNode.setBeatDiv((AstVariable)beatDivSwitch.doSwitch(element));
            graphNode.setStart((AstVariable)startSwitch.doSwitch(element));
        }
    }

    private void buildGraph(List<GraphNode> processingList, Map<EObject, GraphNode> map) {
        Switch<Collection<EObject>> childrenSwitch = this.sequencerSupport.getChildrenSwitch();
        ArrayList<GraphNode> newProcessingList = new ArrayList<GraphNode>();
        while (!processingList.isEmpty()) {
            for (GraphNode treeNode : processingList) {
                Collection children = (Collection)childrenSwitch.doSwitch(treeNode.element);
                for (EObject eObject : children) {
                    if (eObject == null) continue;
                    GraphNode childGraphNode = map.get(eObject);
                    if (childGraphNode == null) {
                        childGraphNode = new GraphNode(this.counter++, eObject, this.sequencerSupport.getNameFunction());
                        newProcessingList.add(childGraphNode);
                        map.put(eObject, childGraphNode);
                    }
                    if (childGraphNode.isPredecessor(treeNode)) continue;
                    childGraphNode.addParent(treeNode);
                }
            }
            processingList.clear();
            processingList.addAll(newProcessingList);
            newProcessingList.clear();
        }
    }
}

