/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.staticsequencer.core;

import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;

public class GraphNode {
    public final EObject element;
    private final Function<EObject, String> nameFunction;
    public final int id;
    private final List<GraphNode> parents = new ArrayList<GraphNode>();
    private AstVariable start;
    private AstVariable beatDiv;

    public GraphNode(int id, EObject element, Function<EObject, String> nameFunction) {
        this.id = id;
        this.element = element;
        this.nameFunction = nameFunction;
    }

    public AstVariable getStart() {
        return this.start;
    }

    public void setStart(AstVariable start) {
        this.start = start;
    }

    public AstVariable getBeatDiv() {
        return this.beatDiv;
    }

    public void setBeatDiv(AstVariable beatDiv) {
        this.beatDiv = beatDiv;
    }

    public void addParent(GraphNode parent) {
        this.parents.add(parent);
    }

    public List<GraphNode> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public boolean isPredecessor(GraphNode graphNode) {
        if (graphNode == this) {
            return true;
        }
        for (GraphNode parent : graphNode.parents) {
            if (!this.isPredecessor(parent)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.nameFunction.apply(this.element);
    }

    public String toString() {
        return "GraphNode [id=" + this.id + ", element=" + this.getName() + "]";
    }
}

