/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.staticsequencer.core;

import com.nxp.s32ds.mdt.icf.staticsequencer.core.GraphNode;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.Helpers;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.Messages;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.AstVariable;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.BinaryExpression;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.LiteralExpression;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.MaxParentVariable;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.MaxVariable;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.MinVariable;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.NodeDelegateVariable;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.NodeVariable;
import com.nxp.s32ds.mdt.icf.staticsequencer.core.ast.VariableExpression;
import org.eclipse.osgi.util.NLS;

public class BeatDivHelper {
    public static AstVariable createFdmaBeatDiv(GraphNode node, int lineIncrement) {
        return new MaxVariable(MaxParentVariable.createBeatDiv(node), NodeVariable.createBeatDiv(node, lineIncrement));
    }

    public static AstVariable createInputPortBeatDiv(GraphNode portSourceNode, GraphNode engineNode, int lineIncrement) {
        if (lineIncrement == 0) {
            throw new IllegalStateException(NLS.bind((String)Messages.BeatDivHelper_value_should_not_be_zero, (Object)lineIncrement));
        }
        AstVariable beatDiv = NodeDelegateVariable.createBeatDiv(portSourceNode);
        return new MaxVariable(beatDiv, NodeVariable.createBeatDiv(engineNode, BinaryExpression.mult(VariableExpression.var(beatDiv), new LiteralExpression(lineIncrement))));
    }

    public static AstVariable createBufferBeatDiv(GraphNode bufferProducerNode, GraphNode bufferNode, int lineIncrement) {
        Helpers.validateBufferProducer(bufferProducerNode, bufferNode);
        if (lineIncrement == 0) {
            throw new IllegalStateException(NLS.bind((String)Messages.BeatDivHelper_value_should_not_be_zero, (Object)lineIncrement));
        }
        AstVariable beatDiv = NodeDelegateVariable.createBeatDiv(bufferProducerNode);
        return new MinVariable(beatDiv, NodeVariable.createBeatDiv(bufferNode, BinaryExpression.div(VariableExpression.var(beatDiv), new LiteralExpression(lineIncrement))));
    }

    public static AstVariable createDefaultBeatDiv(GraphNode node) {
        return MaxParentVariable.createBeatDiv(node);
    }
}

