/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.validation;

import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.validation.S32DebuggerFlashProgrammerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerParams;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerAttributesValidator;
import com.nxp.s32ds.debug.ide.validation.CommonFieldValidator;
import com.nxp.s32ds.debug.ide.validation.ErrorMessages;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class S32DebuggerFlashProgrammerAttributesValidator {
    private S32DebuggerAttributesValidator s32DebuggerAttributesValidator = new S32DebuggerAttributesValidator();

    public String getVirtualIP() {
        return this.s32DebuggerAttributesValidator.getVirtualDeviceIP();
    }

    public List<IStatus> validateDebuggerParameters(S32DebuggerFlashProgrammerParams debuggerParams, boolean checkForLaunch) {
        String deviceName = debuggerParams.getDevice();
        IStatus nameStatus = new CommonFieldValidator("", false, false).validate((Object)("n/a".equals(deviceName) ? "" : deviceName));
        if (nameStatus.getSeverity() != 0) {
            ArrayList<IStatus> error = new ArrayList<IStatus>(1);
            error.add((IStatus)new Status(nameStatus.getSeverity(), "com.nxp.s32ds.debug.ide.s32debugger.flash.validation", S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_select_device));
            return error;
        }
        return this.s32DebuggerAttributesValidator.validateDebuggerParameters(debuggerParams.getS32DebuggerParams(), checkForLaunch);
    }

    public IStatus validateProjectParameters(S32DebuggerFlashProgrammerParams flashProgrammerParams) {
        Map<String, String> idToBinaryMap = flashProgrammerParams.getIdToBinaryMap();
        Map<String, String> binaryIdIsEnabledMap = flashProgrammerParams.getBinaryIdIsEnabledMap();
        Map<String, String> binaryIdToProjectNameMap = flashProgrammerParams.getBinaryIdToProjectNameMap();
        boolean allDisabled = true;
        for (String binaryId : idToBinaryMap.keySet()) {
            ICProject project;
            if (!"enabled".equals(binaryIdIsEnabledMap.get(binaryId))) continue;
            String projectName = binaryIdToProjectNameMap.get(binaryId);
            if (!("<undefined>".equals(projectName) || (project = CoreModel.getDefault().getCModel().getCProject(projectName)) != null && project.exists())) {
                return new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.flash.validation", NLS.bind((String)S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_project_not_exist, (Object)projectName));
            }
            String binaryPath = idToBinaryMap.get(binaryId);
            String absoluteBinaryPath = DebuggerUtils.getAbsoluteBinaryPathByProjectName((String)projectName, (String)binaryPath);
            if (absoluteBinaryPath == null) {
                return new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.flash.validation", NLS.bind((String)S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_binary_not_exist, (Object)binaryPath));
            }
            File binary = new File(absoluteBinaryPath);
            if (!binary.exists()) {
                return new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.flash.validation", NLS.bind((String)S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_binary_not_exist, (Object)binary.getName()));
            }
            if (!allDisabled) continue;
            allDisabled = false;
        }
        if (allDisabled) {
            return new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.flash.validation", S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_select_at_least_one_application);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateMainTabParameters(S32DebuggerFlashProgrammerParams mainParams) {
        return this.validateProjectParameters(mainParams);
    }

    public IStatus validateFlashParameters(S32DebuggerFlashProgrammerParams flashProgrammerParams, boolean checkForLaunch) {
        ArrayList errors = new ArrayList();
        errors.addAll(this.validateDebuggerParameters(flashProgrammerParams, checkForLaunch));
        errors.add(this.validateMainTabParameters(flashProgrammerParams));
        errors = (ArrayList)errors.stream().filter(status -> status.getSeverity() == 4).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            return new MultiStatus("com.nxp.s32ds.debug.ide.s32debugger.flash.validation", 4, errors.toArray(new IStatus[0]), ErrorMessages.LaunchSequence_wrong_attributes, null);
        }
        return Status.OK_STATUS;
    }
}

