/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.validation;

import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashCapableLaunchConfigurationMarker;
import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;

public class S32DebuggerFlashCompatibilityLaunchValidator
implements IResourceChecker {
    public static final String BUNDLE_ID = "com.nxp.s32ds.debug.ide.s32debugger.flash.validation";
    private static final String FILE_EXTENSION = "launch";
    public static final String ATTR_BINARIES_LIST = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.projectBinariesList";
    public static final String ATTR_BINARIES_ENABLED_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binariesEnabledMap";
    public static final String ATTR_BINARIES_TO_BASE_ADDRESS_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryToBaseAddressMap";
    public static final String ATTR_BINARIES_TO_PROJECT_NAME_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryToProjectNameMap";
    private static final List<String> deprecatedAttributes = new ArrayList<String>();

    static {
        deprecatedAttributes.add(ATTR_BINARIES_LIST);
        deprecatedAttributes.add(ATTR_BINARIES_ENABLED_MAP);
        deprecatedAttributes.add(ATTR_BINARIES_TO_BASE_ADDRESS_MAP);
        deprecatedAttributes.add(ATTR_BINARIES_TO_PROJECT_NAME_MAP);
    }

    public IStatus check(IResource resource, IProgressMonitor monitor) {
        IStatus launchValidationStatus = this.checkLaunchConfiguration(resource, monitor);
        return launchValidationStatus;
    }

    private IStatus checkLaunchConfiguration(IResource resource, IProgressMonitor monitor) {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            ICProjectDescription desc = CCorePlugin.getDefault().getProjectDescription(project, true);
            if (desc != null) {
                try {
                    List<IFile> listLaunchFiles = this.launchFilesFinder((IContainer)resource);
                    return this.launchValidation(listLaunchFiles, project, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private List<IFile> launchFilesFinder(IContainer container) throws CoreException {
        IResource[] members;
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            String fileExtension;
            IResource member = iResourceArray[n2];
            if (member instanceof IContainer) {
                files.addAll(this.launchFilesFinder((IContainer)member));
            } else if (member instanceof IFile && (fileExtension = (file = (IFile)member).getFileExtension()) != null && fileExtension.contains(FILE_EXTENSION)) {
                files.add(file);
            }
            ++n2;
        }
        return files;
    }

    private IStatus launchValidation(List<IFile> listLaunchFiles, IProject project, IProgressMonitor monitor) {
        MultiStatus ms = new MultiStatus(BUNDLE_ID, 0, new String(), null);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        for (IFile launchFile : listLaunchFiles) {
            if (!launchFile.exists()) continue;
            ILaunchConfiguration launchConfiguration = launchManager.getLaunchConfiguration(launchFile);
            try {
                if (!this.hasDeprecatedLaunchAttributes(launchConfiguration, project.getName()) || S32DebuggerFlashCapableLaunchConfigurationMarker.containsMarker((IResource)launchFile)) continue;
                ms.add(S32DebuggerFlashCapableLaunchConfigurationMarker.createMarker((IResource)launchFile, project));
            }
            catch (CoreException e) {
                ms.add(e.getStatus());
            }
        }
        return ms;
    }

    private boolean hasDeprecatedLaunchAttributes(ILaunchConfiguration launchConfiguration, String validValue) throws CoreException {
        for (String attributeName : deprecatedAttributes) {
            if (!launchConfiguration.hasAttribute(attributeName)) continue;
            return true;
        }
        return false;
    }
}

