/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.validation;

import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.ErrorMessages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class S32DebuggerFlashCapableLaunchConfigurationMarker {
    private static final String MARKER_ID = "com.nxp.s32ds.debug.ide.s32debugger.flash.validation.capable.launch.marker";

    public static IStatus createMarker(IResource launchFile, IProject project) {
        try {
            IMarker marker = launchFile.createMarker(MARKER_ID);
            if (marker.exists()) {
                marker.setAttribute("severity", 1);
                String msg = NLS.bind((String)ErrorMessages.S32DebuggerFlashCapableLaunchConfigurationMarker_UserWarningMessage, (Object)launchFile.getName());
                marker.setAttribute("message", (Object)msg);
                marker.setAttribute("location", (Object)project.getName());
                marker.setAttribute(ErrorMessages.S32DebuggerFlashCapableLaunchConfigurationMarker_MarkerAttFileName, (Object)launchFile.getName());
                String fixMsg = NLS.bind((String)ErrorMessages.S32DebuggerFlashCapableLaunchConfigurationMarker_UserFixMessage, (Object)launchFile.getName());
                marker.setAttribute(ErrorMessages.S32DebuggerFlashCapableLaunchConfigurationMarker_MarkerAttFixMessage, (Object)fixMsg);
            }
        }
        catch (CoreException ce) {
            ResourcesPlugin.getPlugin().getLog().log(ce.getStatus());
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static IStatus delete(IResource resource) {
        try {
            resource.deleteMarkers(MARKER_ID, true, 2);
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static boolean containsMarker(IResource resource) {
        try {
            IMarker[] markers = resource.findMarkers(MARKER_ID, true, 2);
            if (markers != null && markers.length > 0) {
                return true;
            }
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
        return false;
    }
}

