/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.core.linux;

import com.nxp.s32ds.debug.ide.core.USBDeviceAccessor;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class S32DebuggerUSBDeviceAccessorImpl
implements USBDeviceAccessor {
    private static final String SH_RUNNER_REQUEST = "/bin/sh";
    private static final String DMESG_USB_NUMBER_BY_VID_PID_REQUEST = "dmesg | grep '%s.*%s' | awk -F'usb |:' '{print $2}'";
    private static final String DMESG_HARDWARE_ADDRESS_REQUEST = "dmesg | grep -e '%s.*register' | awk -F', ' '{print $3}'";
    private static final String DMESG_USB_DEVICE_PRODUCT = "dmesg | grep -e '%s.*Product:' | awk -F': ' '{print $3}'";
    private static final String DMESG_USB_DEVICE_SERIAL_NUMBER = "dmesg | grep -e '%s.*SerialNumber:' | awk -F': ' '{print $3}'";
    private static final String NMCLI_CONNECTIONS_REQUEST = "nmcli connection show | grep 'ethernet' | awk -F'  ' '{print $1}'";
    private static final String NMCLI_CONNECTION_MAC_REQUEST = "nmcli connection show '%s' | grep '\\.mac-address:' | awk '{print $2}'";
    private static final String NMCLI_CONNECTION_DHCP_REQUEST = "nmcli connection show '%s' | grep 'dhcp_server_identifier' | awk -F' = ' '{print $2}'";
    private static final String UNKNOWN = "UNKNOWN DEVICE";

    public Collection<String> getActiveTAPDevices() {
        return this.getActiveDevices("15A2", "0067");
    }

    public Collection<String> getActiveCMSISDAPDevices() {
        Collection<String> lpcLinkIIDevices = this.getActiveDevices("1FC9", "0090");
        Collection<String> greenBoxIIDevices = this.getActiveDevices("0D28", "0204");
        HashSet<String> cmsisDapDevices = new HashSet<String>(lpcLinkIIDevices);
        cmsisDapDevices.addAll(greenBoxIIDevices);
        return cmsisDapDevices;
    }

    private Collection<String> getActiveDevices(String vid, String pid) {
        HashSet<String> devices = new HashSet<String>();
        List<String> processOutput = this.runProcessForOutput(String.format(DMESG_USB_NUMBER_BY_VID_PID_REQUEST, vid.toLowerCase(), pid.toLowerCase()));
        HashSet<String> usbNumbersNoDuplicates = new HashSet<String>(processOutput);
        for (String usbNumber : usbNumbersNoDuplicates) {
            List<String> names;
            List<String> hwAddresses = this.runProcessForOutput(String.format(DMESG_HARDWARE_ADDRESS_REQUEST, usbNumber));
            String hwAddress = null;
            if (!hwAddresses.isEmpty()) {
                if (hwAddresses.size() % 2 == 0) continue;
                hwAddress = hwAddresses.get(hwAddresses.size() - 1);
            }
            String productName = !(names = this.runProcessForOutput(String.format(DMESG_USB_DEVICE_PRODUCT, usbNumber))).isEmpty() ? names.get(names.size() - 1) : UNKNOWN;
            List<String> serials = this.runProcessForOutput(String.format(DMESG_USB_DEVICE_SERIAL_NUMBER, usbNumber));
            if (serials.isEmpty()) continue;
            String productSerial = serials.get(serials.size() - 1);
            StringBuilder deviceBuilder = new StringBuilder();
            deviceBuilder.append(String.format("VID_%s&PID_%s", vid, pid));
            deviceBuilder.append("--");
            if (hwAddress != null) {
                deviceBuilder.append(hwAddress);
                deviceBuilder.append("--");
            } else {
                deviceBuilder.append(productSerial);
                deviceBuilder.append("--");
            }
            deviceBuilder.append(productSerial);
            deviceBuilder.append(" - ");
            deviceBuilder.append(productName);
            devices.add(deviceBuilder.toString());
        }
        return devices;
    }

    private List<String> runProcessForOutput(String toExecute) {
        Process process = null;
        BufferedReader reader = null;
        String[] unixExecute = new String[]{SH_RUNNER_REQUEST, "-c", toExecute};
        try {
            process = Runtime.getRuntime().exec(unixExecute);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            S32DebuggerCoreActivator.log((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.core", "IO exception when reading process output" + e.getMessage()));
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    S32DebuggerCoreActivator.log((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.core", "IO exception when reading process output" + e.getMessage()));
                }
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    public String getVirtualIP(String device) {
        String[] deviceIDs = device.split("--");
        String deviceVidPid = deviceIDs[0];
        String deviceSerial = deviceIDs[1];
        if (S32DEBUGGER_DEVICE_ID.equals(deviceVidPid)) {
            String dhcpAddress = null;
            dhcpAddress = null;
            List<String> hwInterfaces = this.runProcessForOutput(NMCLI_CONNECTIONS_REQUEST);
            for (String hwInterface : hwInterfaces) {
                List<String> macAddressResult = this.runProcessForOutput(String.format(NMCLI_CONNECTION_MAC_REQUEST, hwInterface));
                if (macAddressResult.isEmpty() || !macAddressResult.get(0).equalsIgnoreCase(deviceSerial)) continue;
                List<String> dhcpAddresses = this.runProcessForOutput(String.format(NMCLI_CONNECTION_DHCP_REQUEST, hwInterface));
                if (dhcpAddresses.isEmpty() || !(dhcpAddress = dhcpAddresses.get(0)).isEmpty()) break;
                dhcpAddress = null;
                break;
            }
            return dhcpAddress != null ? "s32dbg:" + dhcpAddress : null;
        }
        if (CMSIS_DAP_GREEN_BOX_DEVICE_ID.equals(deviceVidPid) || CMSIS_DAP_LPC_DEVICE_ID.equals(deviceVidPid)) {
            return "cmsisdap#" + deviceSerial;
        }
        return null;
    }
}

