/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core.operations;

import com.nxp.s32ds.rcp.modular.ModularObject;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMessages;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMetaModelReader;
import com.nxp.s32ds.rcp.modular.internal.core.ModularOperationStatusImpl;
import com.nxp.s32ds.rcp.modular.internal.core.ModularUtils;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.operations.RemedyConfig;

public abstract class ModularOperation {
    private final ProvisioningSession provisioningSession;
    private String profileId = "_SELF_";
    private final ModularMetaModelReader metaModelReader;

    public ModularOperation(ProvisioningSession provisioningSession, ModularMetaModelReader metaModelReader) {
        this.provisioningSession = provisioningSession;
        this.metaModelReader = metaModelReader;
    }

    public void executeOperation(ProfileChangeOperation operation, IProgressMonitor progressMonitor) throws OperationCanceledException {
        operation.getProvisioningJob(progressMonitor).run(progressMonitor);
    }

    abstract ProfileChangeOperation getProfileChangeOperation(Collection<IInstallableUnit> var1, String var2, ProvisioningSession var3);

    protected ProvisioningContext getProvisioningContext() {
        return new ProvisioningContext(this.provisioningSession.getProvisioningAgent());
    }

    private void computeRemediationOperation(ProfileChangeOperation op, RemediationOperation remediationOperation, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)ModularMessages.InstallJobCreater_ComputeRemediationOperation, (int)RemedyConfig.getAllRemedyConfigs().length);
        monitor.setTaskName(ModularMessages.InstallJobCreater_ComputeRemediationOperation);
        remediationOperation.resolveModal(monitor);
        sub.done();
    }

    abstract ModularOperationStatusImpl getResolutionStatus(Collection<ModularObject> var1, IProgressMonitor var2);

    protected ModularOperationStatusImpl getStatus(Collection<IInstallableUnit> units, Collection<ModularObject> modularObjects, IProgressMonitor progressMonitor) throws ProvisionException {
        ProvisioningContext provisioningContext = this.getProvisioningContext();
        ProfileChangeOperation profileChangeOperation = null;
        RemediationOperation remediationOperation = null;
        if (!units.isEmpty()) {
            profileChangeOperation = this.getProfileChangeOperation(units, this.getProfileId(), this.getProvisioningSession());
            if (this.getProvisioningSession().hasScheduledOperationsFor(this.getProfileId())) {
                return new ModularOperationStatusImpl((IStatus)new Status(4, ModularInstallerActivator.getContext().getBundle().getSymbolicName(), ModularMessages.InstallJobCreater_Operation_Already_In_Progress), profileChangeOperation, null, modularObjects, this.getProvisioningSession());
            }
            profileChangeOperation.setProvisioningContext(provisioningContext);
            if (ModularUtils.shouldRemediate(profileChangeOperation.resolveModal(progressMonitor))) {
                remediationOperation = new RemediationOperation(this.provisioningSession, profileChangeOperation.getProfileChangeRequest());
                this.computeRemediationOperation(profileChangeOperation, remediationOperation, progressMonitor);
            }
            IStatus resolutionResult = profileChangeOperation.getResolutionResult();
            return new ModularOperationStatusImpl(resolutionResult, profileChangeOperation, remediationOperation, modularObjects, this.getProvisioningSession());
        }
        throw new ProvisionException((IStatus)new Status(4, ModularInstallerActivator.getContext().getBundle().getSymbolicName(), ModularMessages.InstallJobCreater_NoUnitsToInstall));
    }

    protected ProvisioningSession getProvisioningSession() {
        return this.provisioningSession;
    }

    protected String getProfileId() {
        return this.profileId;
    }

    protected ModularMetaModelReader getModularMetaModelReader() {
        return this.metaModelReader;
    }
}

