/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core;

import com.nxp.s32ds.rcp.modular.HWFamily;
import com.nxp.s32ds.rcp.modular.HWdevice;
import com.nxp.s32ds.rcp.modular.ModularFactory;
import com.nxp.s32ds.rcp.modular.ModularFeature;
import com.nxp.s32ds.rcp.modular.ModularObject;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.ModularRegistry;
import com.nxp.s32ds.rcp.modular.internal.ModularFeatureImplementation;
import com.nxp.s32ds.rcp.modular.internal.ModularPackImplementation;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMessages;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMetaModelReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.osgi.util.tracker.ServiceTracker;

public class ModularUtils {
    private static final String PRODUCT_FEATURE = "product.feature";
    public static final String DF_LT = "df_LT.";
    public static final String MODULAR_META_MODEL_READER_FEATURE_DESCRIPTION = "df_LT.description";
    public static final String MODULAR_META_MODEL_READER_FEATURE_NAME = "df_LT.featureName";
    public static final String MODULAR_META_MODEL_READER_PACK_DESCRIPTION = "com.nxp.s32ds.pack.description";
    public static final String MODULAR_META_MODEL_READER_PACK_ICON = "com.nxp.s32ds.pack.icon";
    public static final String MODULAR_META_MODEL_READER_PACK_VERSION = "com.nxp.s32ds.pack.version";
    public static final String MODULAR_META_MODEL_READER_PACK_UNISTALLABLE = "com.nxp.s32ds.pack.uninstallable";
    public static final String MODULAR_META_MODEL_READER_PACK_NAME = "com.nxp.s32ds.pack.name";
    public static final String MODULAR_META_MODEL_READER_PACK_ID = "com.nxp.s32ds.pack.id";
    public static final String INSTALLER_FEATURE_GROUP_SUFFIX = "feature.feature.group";
    public static final String INSTALLER_FEATUR_ROOT_SUFFIX = "feature_root";
    public static final String MODULAR_META_MODEL_READER_PACK_CLL_LICENSE = "com.nxp.s32ds.pack.licenseinfo";
    public static final String MODULAR_META_MODEL_READER_PACK_OS = "com.nxp.s32ds.pack.os";
    public static final String MODULAR_META_MODEL_READER_PACK_ARCHITECTURE = "com.nxp.s32ds.pack.architecture";
    public static final String MODULAR_META_MODEL_READER_PACK_HARDWARE = "com.nxp.s32ds.pack.hardware";
    public static final String MODULAR_META_MODEL_READER_PACKSUPPORT_PRODUCTS = "com.nxp.s32ds.pack.support.products";
    public static final String OS_WIN = "win32";
    public static final String OS_LINUX = "linux";
    public static final String OS_ARCHITECTURE_x86 = "x86";
    public static final String OS_ARCHITECTURE_x86_64 = "x86_64";
    private static final String GROUP_PARAMETRS_PATTERN = "(.*)(\\[.*\\])";
    private static final String GROUP_SPLITTER = ";";
    private static final String ELEMENT_SPLITTER = ",";
    private static ModularFactory factory;

    private ModularUtils() {
    }

    public static IMetadataRepository loadMetadataRepository(URI uri, IMetadataRepositoryManager metaRepositorymanager, IArtifactRepositoryManager artifactRepositoryManager, IProgressMonitor progressMonitor) throws ProvisionException, OperationCanceledException {
        IMetadataRepository repo = null;
        artifactRepositoryManager.loadRepository(uri, progressMonitor);
        repo = metaRepositorymanager.loadRepository(uri, progressMonitor);
        String name = metaRepositorymanager.getRepositoryProperty(uri, "p2.nickname");
        if ((name == null || name.length() == 0) && (name = repo.getName()) != null && name.length() > 0) {
            metaRepositorymanager.setRepositoryProperty(uri, "p2.nickname", name);
        }
        return repo;
    }

    public static ModularFactory getModularFactory() {
        if (factory == null) {
            ServiceTracker serviceTracker = new ServiceTracker(ModularInstallerActivator.getContext(), ModularRegistry.class.getName(), null);
            serviceTracker.open();
            ModularRegistry modularRegistry = (ModularRegistry)serviceTracker.getService();
            factory = modularRegistry.getModularFactory();
        }
        return factory;
    }

    public static IInstallableUnit getFeatureGroupInstalledUnitByRootInstalledUnit(IQueryable<IInstallableUnit> queryable, IInstallableUnit unit, IProgressMonitor progressMonitor) {
        IInstallableUnit installableUnit = null;
        if (unit != null && unit.getId().endsWith(INSTALLER_FEATUR_ROOT_SUFFIX)) {
            for (IInstallableUnit iInstallableUnit : queryable.query(QueryUtil.ALL_UNITS, progressMonitor)) {
                String id = String.valueOf(unit.getId().substring(0, unit.getId().indexOf(INSTALLER_FEATUR_ROOT_SUFFIX))) + INSTALLER_FEATURE_GROUP_SUFFIX;
                if (!id.equals(iInstallableUnit.getId())) continue;
                installableUnit = iInstallableUnit;
                break;
            }
        }
        return installableUnit;
    }

    public static Collection<ILicense> setAllLicenseFromAllRequiredUnit(IInstallableUnit iInstallableUnit, IQueryable<IInstallableUnit> inputQuery, IQueryable<IInstallableUnit> picker, IProgressMonitor monitor) {
        ArrayList<ILicense> iLicenses = new ArrayList<ILicense>();
        IInstallableUnit installableUnit = ModularUtils.getFeatureGroupInstalledUnitByRootInstalledUnit(inputQuery, iInstallableUnit, (IProgressMonitor)new NullProgressMonitor());
        if (installableUnit != null) {
            List<IInstallableUnit> installableUnits = ModularUtils.getRequirementsUnit(picker, installableUnit, monitor);
            for (IInstallableUnit unit : installableUnits) {
                for (ILicense iLicense : unit.getLicenses(null)) {
                    if (iLicense.getBody().startsWith("%")) {
                        String licenseProperty = iLicense.getBody().substring(1);
                        String property = unit.getProperty(DF_LT + licenseProperty);
                        if (property == null) continue;
                        iLicenses.add(MetadataFactory.createLicense((URI)iLicense.getLocation(), (String)property));
                        continue;
                    }
                    iLicenses.add(iLicense);
                }
            }
            return iLicenses;
        }
        return null;
    }

    public static List<IInstallableUnit> getRequirementsUnit(IQueryable<IInstallableUnit> picker, IInstallableUnit installableUnit, IProgressMonitor progressMonitor) {
        Collection requirements = installableUnit.getRequirements();
        ArrayList<IInstallableUnit> installableUnits = new ArrayList<IInstallableUnit>();
        for (IRequirement req : requirements) {
            IQuery query = QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]);
            IQueryResult matches = picker.query(query, progressMonitor);
            for (IInstallableUnit unit : matches) {
                installableUnits.add(unit);
            }
        }
        return installableUnits;
    }

    public static void getInstallUnitByURI(Collection<ModularObject> modularObjects, IProgressMonitor progressMonitor, Collection<IInstallableUnit> unitsToInstall, ModularMetaModelReader metaModelReader, IProvisioningAgent agent) throws ProvisionException {
        ArrayList<ModularObject> objectsFromRepository = new ArrayList<ModularObject>();
        for (ModularObject modularObject : modularObjects) {
            IQueryResult query;
            IInstallableUnit unit;
            IArtifactRepositoryManager artifactRepositoryManager;
            URI uri = modularObject.getUri();
            if (uri == null) {
                if (objectsFromRepository.isEmpty()) {
                    objectsFromRepository.addAll(metaModelReader.readMetamodelfromUri(metaModelReader.getEnabledRepositories(progressMonitor), agent, progressMonitor));
                }
                for (ModularObject object : objectsFromRepository) {
                    if (!object.getId().equals(modularObject.getId()) || object.getUri() == null) continue;
                    uri = object.getUri();
                }
            }
            if (uri == null) {
                throw new ProvisionException(String.format(ModularMessages.ModularUtils_MissingModularException, modularObject.getName(), modularObject.getId()));
            }
            IMetadataRepositoryManager metaRepositorymanager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IMetadataRepository repository = ModularUtils.loadMetadataRepository(uri, metaRepositorymanager, artifactRepositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME), progressMonitor);
            IInstallableUnit installableUnit = ModularUtils.getFeatureGroupInstalledUnitByRootInstalledUnit((IQueryable<IInstallableUnit>)repository, unit = (IInstallableUnit)(query = repository.query(QueryUtil.createIUPropertyQuery((String)MODULAR_META_MODEL_READER_PACK_ID, (String)modularObject.getId()), progressMonitor)).iterator().next(), progressMonitor);
            if (installableUnit != null) {
                unitsToInstall.add(installableUnit);
                continue;
            }
            if (unit.getId() == null || !unit.getId().contains(PRODUCT_FEATURE)) continue;
            unitsToInstall.add(unit);
        }
    }

    private static void readSubUnit(IProgressMonitor progressMonitor, URI uri, IQueryResult<IInstallableUnit> query, IInstallableUnit q, ModularPack modularPack) {
        IInstallableUnit groupUnit;
        if (query != null && (groupUnit = ModularUtils.getFeatureGroupInstalledUnitByRootInstalledUnit(query, q, progressMonitor)) != null) {
            ModularUtils.getModularFactory().setP2FeatureIdToPack(modularPack, groupUnit.getId());
            ModularUtils.getModularFactory().setP2FeatureVersionToPack(modularPack, groupUnit.getVersion().toString());
            List<IInstallableUnit> requirementsUnit = ModularUtils.getRequirementsUnit(query, groupUnit, progressMonitor);
            ModularUtils.getModularFactory().addAllthirdPartyIds(modularPack, ModularUtils.findThirdPartyFeatureIds(requirementsUnit, groupUnit));
            for (IInstallableUnit iInstallableUnit : requirementsUnit) {
                String cllLicense;
                ModularFeature feature = ModularUtils.getModularFactory().createFeature(iInstallableUnit.getId(), iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_FEATURE_NAME), iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_FEATURE_DESCRIPTION), iInstallableUnit.getVersion().toString(), uri);
                if (feature instanceof ModularFeatureImplementation && feature.getDescription() != null && !feature.getDescription().isEmpty()) {
                    for (ILicense iLicense : iInstallableUnit.getLicenses()) {
                        ModularFeatureImplementation featureImplementation = (ModularFeatureImplementation)feature;
                        featureImplementation.addLicense(iLicense);
                    }
                    ModularUtils.getModularFactory().addModularFeatureToPack(feature, modularPack);
                }
                if ((cllLicense = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_CLL_LICENSE)) == null || cllLicense.isEmpty() || !(modularPack instanceof ModularPackImplementation)) continue;
                ModularPackImplementation modPackImpl = (ModularPackImplementation)modularPack;
                modPackImpl.addModularLicense(cllLicense, modularPack.getName());
            }
        }
    }

    private static Collection<String> findThirdPartyFeatureIds(List<IInstallableUnit> requirementsUnit, IInstallableUnit groupUnit) {
        Set selfRequirmentsIds = requirementsUnit.stream().map(unit -> unit.getId()).collect(Collectors.toSet());
        HashSet<String> thirdPartyIds = new HashSet<String>();
        for (IRequirement iRequirement : groupUnit.getRequirements()) {
            String id = (String)iRequirement.getMatches().getParameters()[0];
            if (selfRequirmentsIds.contains(id)) continue;
            thirdPartyIds.add(id);
        }
        return thirdPartyIds;
    }

    public static Collection<ModularObject> getInstalledUnit(IProfileRegistry profileRegistry, IProgressMonitor progressMonitor) {
        if (profileRegistry == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList<ModularObject> modularObjects = new ArrayList<ModularObject>();
        IProfile profile = profileRegistry.getProfile("_SELF_");
        IQueryResult queryResult = profile.query(QueryUtil.ALL_UNITS, progressMonitor);
        for (IInstallableUnit iInstallableUnit : queryResult) {
            ModularPack createModularPackByIInstableUnit;
            if (iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_ID) == null || (createModularPackByIInstableUnit = ModularUtils.createModularPackByIInstableUnit(iInstallableUnit, (IQueryResult<IInstallableUnit>)queryResult, progressMonitor, null)) == null) continue;
            modularObjects.add((ModularObject)createModularPackByIInstableUnit);
        }
        return modularObjects;
    }

    public static ModularPack createModularPackByIInstableUnit(IInstallableUnit iInstallableUnit, IQueryResult<IInstallableUnit> query, IProgressMonitor progressMonitor, URI uri) {
        if (iInstallableUnit != null) {
            if (!ModularUtils.isAcceptableOS(iInstallableUnit) || !ModularUtils.isAcceptableAtrchitecture(iInstallableUnit)) {
                return null;
            }
            ModularPack modularPack = ModularUtils.getModularFactory().createPack(iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_ID), iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_NAME), iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_DESCRIPTION), iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_VERSION), uri);
            if (modularPack instanceof ModularPackImplementation) {
                String supportProducts;
                String hardware;
                String isUninstall;
                ModularPackImplementation packImplementation = (ModularPackImplementation)modularPack;
                String iconB64 = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_ICON);
                if (iconB64 != null && !iconB64.isEmpty()) {
                    packImplementation.setIcon(iconB64);
                }
                for (ILicense iLicense : iInstallableUnit.getLicenses()) {
                    packImplementation.addLicense(iLicense);
                }
                String cllLicense = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_CLL_LICENSE);
                if (cllLicense != null && !cllLicense.isEmpty()) {
                    packImplementation.addModularLicense(cllLicense, modularPack.getName());
                }
                if ((isUninstall = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_UNISTALLABLE)) != null && !isUninstall.isEmpty()) {
                    packImplementation.setUninstall(Boolean.parseBoolean(isUninstall));
                }
                if ((hardware = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_HARDWARE)) != null && !hardware.isEmpty()) {
                    ModularUtils.setHardwareToModularPack(hardware, modularPack);
                }
                if ((supportProducts = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACKSUPPORT_PRODUCTS)) != null && !supportProducts.isEmpty()) {
                    ModularUtils.setSupportProductsToModularPack(supportProducts, modularPack);
                }
                ModularUtils.readSubUnit(progressMonitor, uri, query, iInstallableUnit, modularPack);
                packImplementation.setIcon(iconB64);
            }
            return modularPack;
        }
        return null;
    }

    private static void setHardwareToModularPack(String hardware, ModularPack modularPack) {
        String[] split = hardware.split(GROUP_SPLITTER);
        Pattern pattern = Pattern.compile(GROUP_PARAMETRS_PATTERN);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            try {
                Matcher matcher = pattern.matcher(string);
                if (matcher.groupCount() != 2) {
                    return;
                }
                if (matcher.find()) {
                    String familyName = matcher.group(1);
                    String devicesString = matcher.group(2);
                    String[] devices = devicesString.substring(1, devicesString.length() - 1).split(ELEMENT_SPLITTER);
                    HWFamily family = new HWFamily(familyName.trim());
                    String[] stringArray2 = devices;
                    int n3 = devices.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String deviceName = stringArray2[n4];
                        HWdevice hWdevice = new HWdevice(deviceName.trim());
                        family.addHWdevice(hWdevice);
                        ++n4;
                    }
                    ModularUtils.getModularFactory().addHwFamilyToPack(modularPack, family);
                }
            }
            catch (IllegalStateException | IndexOutOfBoundsException e) {
                ModularInstallerActivator.getDefault().logError(e.getMessage());
                return;
            }
            ++n2;
        }
    }

    private static void setSupportProductsToModularPack(String supportProducts, ModularPack modularPack) {
        String[] split = supportProducts.split(GROUP_SPLITTER);
        Pattern pattern = Pattern.compile(GROUP_PARAMETRS_PATTERN);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            try {
                Matcher matcher = pattern.matcher(string);
                if (matcher.groupCount() != 2) {
                    return;
                }
                if (matcher.find()) {
                    String productName = matcher.group(1);
                    String productVersionsFromString = matcher.group(2);
                    String[] versionsArray = productVersionsFromString.substring(1, productVersionsFromString.length() - 1).split(ELEMENT_SPLITTER);
                    HashSet<String> productVersions = new HashSet<String>();
                    String[] stringArray2 = versionsArray;
                    int n3 = versionsArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String versionName = stringArray2[n4];
                        productVersions.add(versionName);
                        ++n4;
                    }
                    ModularUtils.getModularFactory().addSupportProduct(modularPack, productName, productVersions);
                }
            }
            catch (IllegalStateException | IndexOutOfBoundsException e) {
                ModularInstallerActivator.getDefault().logError(e.getMessage());
                return;
            }
            ++n2;
        }
    }

    public static boolean isAcceptableOS(IInstallableUnit iInstallableUnit) {
        String os = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_OS);
        if (os != null) {
            String paltformOs = Platform.getOS();
            if (paltformOs.equals(OS_WIN) && !os.equals(OS_WIN)) {
                return false;
            }
            if (paltformOs.equals(OS_LINUX) && !os.equals(OS_LINUX)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isAcceptableAtrchitecture(IInstallableUnit iInstallableUnit) {
        String architecture = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_ARCHITECTURE);
        if (architecture != null) {
            String paltformOs = Platform.getOSArch();
            if (paltformOs.equals(OS_ARCHITECTURE_x86) && !architecture.equals(OS_ARCHITECTURE_x86)) {
                return false;
            }
            if (paltformOs.equals(OS_ARCHITECTURE_x86_64) && !architecture.equals(OS_ARCHITECTURE_x86_64)) {
                return false;
            }
        }
        return true;
    }

    public static ModularPack getUpdateModularPack(IInstallableUnit iInstallableUnit, URI uri, IProfileRegistry profileRegistry, IProgressMonitor progressMonitor) {
        IProfile profile = profileRegistry.getProfile("_SELF_");
        IQueryResult queryResult = profile.query(QueryUtil.createIUPropertyQuery((String)MODULAR_META_MODEL_READER_PACK_ID, (String)"*"), progressMonitor);
        String targetId = iInstallableUnit.getId().replace(INSTALLER_FEATURE_GROUP_SUFFIX, "");
        for (IInstallableUnit unit : queryResult) {
            if (!unit.getId().endsWith(INSTALLER_FEATUR_ROOT_SUFFIX) || !unit.getId().replace(INSTALLER_FEATUR_ROOT_SUFFIX, "").equals(targetId)) continue;
            return ModularUtils.createModularPackByIInstableUnit(unit, (IQueryResult<IInstallableUnit>)profileRegistry.getProfile("_SELF_").query(QueryUtil.ALL_UNITS, progressMonitor), progressMonitor, uri);
        }
        return null;
    }

    public static void getInstallUnit(Collection<ModularObject> modularObjects, Collection<IInstallableUnit> updateUnits, IQueryable<IInstallableUnit> query, IProgressMonitor progressMonitor) {
        if (query != null) {
            for (ModularObject modularObject : modularObjects) {
                IQueryResult repository = query.query(QueryUtil.createIUPropertyQuery((String)MODULAR_META_MODEL_READER_PACK_ID, (String)modularObject.getId()), progressMonitor);
                IInstallableUnit unit = (IInstallableUnit)repository.iterator().next();
                IInstallableUnit installableUnit = ModularUtils.getFeatureGroupInstalledUnitByRootInstalledUnit(query, unit, progressMonitor);
                if (installableUnit != null) {
                    updateUnits.add(installableUnit);
                    continue;
                }
                if (unit.getId() == null || !unit.getId().contains(PRODUCT_FEATURE)) continue;
                updateUnits.add(unit);
            }
        }
    }

    public static boolean shouldRemediate(IStatus status) {
        if (status == null) {
            return true;
        }
        return status.getSeverity() == 4;
    }

    public static Collection<IInstallableUnit> checkForUpdates(String profileId, IQuery<IInstallableUnit> query, IProfileRegistry iProfileRegistry, IProvisioningAgent agent, URI[] repos, IPlanner planner) {
        IProfile profile = iProfileRegistry.getProfile(profileId);
        ArrayList<IInstallableUnit> iusWithUpdates = new ArrayList<IInstallableUnit>();
        if (profile == null) {
            return Collections.emptyList();
        }
        ProvisioningContext context = new ProvisioningContext(agent);
        context.setMetadataRepositories(repos);
        if (query == null) {
            query = QueryUtil.createIUAnyQuery();
        }
        for (IInstallableUnit iu : profile.query(query, null)) {
            IQueryResult replacements = planner.updatesFor(iu, context, null);
            if (replacements.isEmpty()) continue;
            IInstallableUnit newUnit = iu;
            for (IInstallableUnit unit : replacements) {
                if (unit.getVersion().compareTo((Object)newUnit.getVersion()) <= 0) continue;
                newUnit = unit;
            }
            iusWithUpdates.add(newUnit);
        }
        return iusWithUpdates;
    }

    public static IQuery<IInstallableUnit> getInstalledUnitQuery(IProgressMonitor monitor, IProfileRegistry iProfileRegistry, String profileId) {
        IProfile profile = iProfileRegistry.getProfile(profileId);
        IQuery iQueryResult = QueryUtil.createIUAnyQuery();
        ArrayList<IInstallableUnit> units = new ArrayList<IInstallableUnit>();
        IQueryResult query = profile.query(QueryUtil.ALL_UNITS, null);
        for (IInstallableUnit iInstallableUnit : query) {
            if (iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_ID) == null) continue;
            units.add(iInstallableUnit);
        }
        ArrayList<IInstallableUnit> swapUnit = new ArrayList<IInstallableUnit>();
        for (IInstallableUnit unit : units) {
            IInstallableUnit installableUnit = ModularUtils.getFeatureGroupInstalledUnitByRootInstalledUnit((IQueryable<IInstallableUnit>)query, unit, monitor);
            if (installableUnit == null) continue;
            swapUnit.add(installableUnit);
        }
        ArrayList<IQuery> iQueries = new ArrayList<IQuery>();
        for (IInstallableUnit iu : swapUnit) {
            iQueries.add(QueryUtil.createIUQuery((String)iu.getId()));
        }
        iQueryResult = QueryUtil.createCompoundQuery(iQueries, (boolean)false);
        return iQueryResult;
    }

    public static IInstallableUnit getFeatureRootInstalledUnitByGroupInstalledUnit(IQueryable<IInstallableUnit> queryable, IInstallableUnit unit, IProgressMonitor progressMonitor) {
        IInstallableUnit installableUnit = null;
        if (unit != null && unit.getId().endsWith(INSTALLER_FEATURE_GROUP_SUFFIX)) {
            for (IInstallableUnit iInstallableUnit : queryable.query(QueryUtil.ALL_UNITS, progressMonitor)) {
                String id = String.valueOf(unit.getId().substring(0, unit.getId().indexOf(INSTALLER_FEATURE_GROUP_SUFFIX))) + INSTALLER_FEATUR_ROOT_SUFFIX;
                if (!id.equals(iInstallableUnit.getId())) continue;
                installableUnit = iInstallableUnit;
                break;
            }
        }
        return installableUnit;
    }

    public static Collection<ModularPack> getUpdateModularPack(Collection<IInstallableUnit> updates, Collection<URI> knownRepositories, IProfileRegistry profileRegistry, IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        ArrayList<ModularPack> collection = new ArrayList<ModularPack>();
        for (IInstallableUnit iInstallableUnit : updates) {
            for (URI uri : knownRepositories) {
                try {
                    IMetadataRepositoryManager metaRepositorymanager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                    IArtifactRepositoryManager artifactRepositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
                    IMetadataRepository repository = ModularUtils.loadMetadataRepository(uri, metaRepositorymanager, artifactRepositoryManager, monitor);
                    IQueryResult result = repository.query(QueryUtil.createIUQuery((String)iInstallableUnit.getId(), (Version)iInstallableUnit.getVersion()), monitor);
                    for (IInstallableUnit unit : result) {
                        if (!unit.getId().equals(iInstallableUnit.getId()) || !unit.getVersion().equals(iInstallableUnit.getVersion())) continue;
                        IQueryResult iQueryResult = repository.query(QueryUtil.ALL_UNITS, monitor);
                        IInstallableUnit featureRootInstalledUnitByGroupInstalledUnit = ModularUtils.getFeatureRootInstalledUnitByGroupInstalledUnit((IQueryable<IInstallableUnit>)repository, unit, monitor);
                        ModularPack createModularPackByIInstableUnit = ModularUtils.createModularPackByIInstableUnit(featureRootInstalledUnitByGroupInstalledUnit, (IQueryResult<IInstallableUnit>)iQueryResult, monitor, uri);
                        if (createModularPackByIInstableUnit == null) continue;
                        collection.add(createModularPackByIInstableUnit);
                    }
                }
                catch (OperationCanceledException | ProvisionException e) {
                    ModularInstallerActivator.getDefault().logError(e.getMessage());
                }
            }
        }
        return collection;
    }

    public static void addLastedPack(ArrayList<ModularObject> modularObjects, ModularPack modularPack) {
        int indexOfModularObjectFromCollections = modularObjects.indexOf(modularPack);
        ModularPack modularPackFromCollections = (ModularPack)modularObjects.get(indexOfModularObjectFromCollections);
        if (modularPack.getVersion().compareToIgnoreCase(modularPackFromCollections.getVersion()) == 0 && modularPack.getP2featureVersion().compareToIgnoreCase(modularPackFromCollections.getP2featureVersion()) > 0) {
            modularObjects.set(indexOfModularObjectFromCollections, (ModularObject)modularPack);
        } else if (modularPack.getVersion().compareToIgnoreCase(modularPackFromCollections.getVersion()) > 0) {
            modularObjects.set(indexOfModularObjectFromCollections, (ModularObject)modularPack);
        }
    }

    public static void removeRepository(URI uri, IProvisioningAgent agent) {
        IMetadataRepositoryManager metaRepositorymanager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IArtifactRepositoryManager artifactRepositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        metaRepositorymanager.removeRepository(uri);
        artifactRepositoryManager.removeRepository(uri);
    }
}

