/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core;

import com.nxp.s32ds.rcp.modular.ModularFeature;
import com.nxp.s32ds.rcp.modular.ModularObject;
import com.nxp.s32ds.rcp.modular.ModularOperationStatus;
import com.nxp.s32ds.rcp.modular.ModularPack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RemediationOperation;

public class ModularOperationStatusImpl
implements ModularOperationStatus {
    private final MultiStatus status;
    private final ProfileChangeOperation operation;
    private final Collection<ModularObject> modularObjects;
    private final ProvisioningSession provisioningSession;
    private final RemediationOperation remediationOperation;

    public ModularOperationStatusImpl(IStatus status, ProfileChangeOperation changeOperation, RemediationOperation remediationOperation, Collection<ModularObject> modularObjects, ProvisioningSession provisioningSession) {
        this.status = new MultiStatus(status.getPlugin(), 0, "", null);
        this.status.add(status);
        this.operation = changeOperation;
        this.remediationOperation = remediationOperation;
        this.modularObjects = modularObjects;
        this.provisioningSession = provisioningSession;
    }

    public ProfileChangeOperation getExecutableOperation() {
        return this.operation;
    }

    public Map<ModularObject, IStatus> getDetailStatus() {
        HashMap<ModularObject, IStatus> map = new HashMap<ModularObject, IStatus>();
        block0: for (ModularObject installableUnit : this.modularObjects) {
            if (!(installableUnit instanceof ModularPack)) continue;
            ModularPack modularPack = (ModularPack)installableUnit;
            IStatus iStatus = this.findParentSatusForModuleById((IStatus)this.status, (IStatus)this.status, modularPack.getId());
            if (iStatus != null && (iStatus.getSeverity() == 4 || iStatus.getSeverity() == 2)) {
                map.put((ModularObject)modularPack, iStatus);
                break;
            }
            ArrayList<IStatus> collection = new ArrayList<IStatus>();
            this.findNestedSatus((IStatus)this.status, collection);
            for (ModularFeature feature : modularPack.getFeatures()) {
                if (feature.getName() == null || (iStatus = this.findSatusForFeature(collection, feature.getName(), modularPack.getId())) == null || iStatus.getSeverity() != 4 && iStatus.getSeverity() != 2) continue;
                map.put((ModularObject)modularPack, iStatus);
                continue block0;
            }
        }
        for (ModularObject modularObject : this.modularObjects) {
            if (map.containsKey(modularObject)) continue;
            map.put(modularObject, Status.OK_STATUS);
        }
        return map;
    }

    private IStatus findParentSatusForModuleById(IStatus parent, IStatus node, String id) {
        if (node.getMessage().contains(id)) {
            return parent;
        }
        IStatus[] iStatusArray = node.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            IStatus result = this.findParentSatusForModuleById(node, status, id);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public void findNestedSatus(IStatus parent, Collection<IStatus> iStatus) {
        IStatus[] iStatusArray = parent.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            iStatus.add(status);
            this.findNestedSatus(status, iStatus);
            ++n2;
        }
    }

    public IStatus findSatusForFeature(Collection<IStatus> iStatus, String featureName, String featureId) {
        HashSet<IStatus> stIStatus = new HashSet<IStatus>();
        for (IStatus status : iStatus) {
            if (!status.getMessage().contains(featureName) && !status.getMessage().contains(featureId)) continue;
            stIStatus.add(status);
        }
        if (stIStatus.isEmpty()) {
            return null;
        }
        int severety = 0;
        StringBuilder builder = new StringBuilder();
        for (IStatus status : stIStatus) {
            if (status.getSeverity() > severety) {
                severety = status.getSeverity();
            }
            builder.append(status.getMessage());
        }
        return new Status(severety, "com.nxp.s32ds.rcp.modular.core", builder.toString());
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    public ProvisioningSession getProvisioningSession() {
        return this.provisioningSession;
    }

    public RemediationOperation getRemediationOperation() {
        return this.remediationOperation;
    }
}

