/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core;

import com.nxp.s32ds.rcp.modular.ModularObject;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.Repository;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularUtils;
import com.nxp.s32ds.rcp.modular.internal.core.RepositoryUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class ModularMetaModelReader {
    private final ProvisioningSession session;

    public ModularMetaModelReader(ProvisioningSession provisioningSession) {
        this.session = provisioningSession;
    }

    public Collection<URI> getEnabledRepositories(IProgressMonitor progressMonitor) {
        IEclipsePreferences pref = ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.rcp.modular.core");
        String string = pref.get("storedRepositories", null);
        HashSet<Repository> repositories = new HashSet<Repository>();
        RepositoryUtils.readRepo(string, repositories);
        return repositories.stream().map(r -> RepositoryUtils.localRepoURIFixer(r.getLocation())).collect(Collectors.toSet());
    }

    public Collection<ModularObject> readMetamodelfromUri(Collection<URI> uris, IProvisioningAgent agent, IProgressMonitor progressMonitor) throws OperationCanceledException {
        ArrayList<ModularObject> modularObjects = new ArrayList<ModularObject>();
        if (agent != null && uris != null) {
            IMetadataRepositoryManager metaRepositorymanager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IArtifactRepositoryManager artifactRepositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            for (URI uri : uris) {
                try {
                    IMetadataRepository repository = ModularUtils.loadMetadataRepository(uri, metaRepositorymanager, artifactRepositoryManager, progressMonitor);
                    IQueryResult query = repository.query(QueryUtil.ALL_UNITS, progressMonitor);
                    if (query == null) continue;
                    for (IInstallableUnit q : query) {
                        ModularPack modularPack;
                        if (!q.getProperties().containsKey("com.nxp.s32ds.pack.id") || (modularPack = ModularUtils.createModularPackByIInstableUnit(q, (IQueryResult<IInstallableUnit>)query, progressMonitor, uri)) == null) continue;
                        if (!modularObjects.contains(modularPack)) {
                            modularObjects.add((ModularObject)modularPack);
                            continue;
                        }
                        ModularUtils.addLastedPack(modularObjects, modularPack);
                    }
                }
                catch (OperationCanceledException | ProvisionException e) {
                    ModularInstallerActivator.getDefault().logError(e.getMessage());
                }
            }
            return modularObjects;
        }
        return Collections.EMPTY_SET;
    }

    public Collection<ModularObject> getInstalledUnit(IProgressMonitor iProgressMonitor) {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.session.getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
        return ModularUtils.getInstalledUnit(profileRegistry, iProgressMonitor);
    }
}

