/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core;

import com.nxp.s32ds.rcp.modular.ModularInstallerService;
import com.nxp.s32ds.rcp.modular.ModularObject;
import com.nxp.s32ds.rcp.modular.ModularOperationStatus;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMessages;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMetaModelReader;
import com.nxp.s32ds.rcp.modular.internal.core.ModularOperationStatusImpl;
import com.nxp.s32ds.rcp.modular.internal.core.UpdateChecker;
import com.nxp.s32ds.rcp.modular.internal.core.operations.InstallModularOperation;
import com.nxp.s32ds.rcp.modular.internal.core.operations.UninstallModularOperation;
import com.nxp.s32ds.rcp.modular.internal.core.operations.UpdateModularOperation;
import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.osgi.service.component.annotations.Component;

@Component
public class ModularInstallerServiceImplementation
implements ModularInstallerService {
    private final InstallModularOperation installModularOperation;
    private final UpdateModularOperation updateModularOperation;
    private final UninstallModularOperation uninstallModularOperation;
    private final ModularMetaModelReader metaModelReader;
    private final ProvisioningSession provisioningSession;
    private final IPlanner planner;
    private final IProfileRegistry profileRegistry;
    private final IProvisioningAgent provisioningAgent;
    private final UpdateChecker updateChecker;

    public ModularInstallerServiceImplementation(IProvisioningAgent iProvisioningAgent) {
        this.provisioningAgent = iProvisioningAgent;
        this.planner = (IPlanner)iProvisioningAgent.getService(IPlanner.SERVICE_NAME);
        this.profileRegistry = (IProfileRegistry)iProvisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
        if (this.planner == null || this.profileRegistry == null) {
            ModularInstallerActivator.getDefault().log((IStatus)new Status(4, ModularInstallerActivator.getContext().getBundle().getSymbolicName(), ModularMessages.ModularInstallerServiceImplementation_ErrorServerInitialization));
        }
        this.provisioningSession = new ProvisioningSession(this.provisioningAgent);
        this.metaModelReader = new ModularMetaModelReader(this.provisioningSession);
        this.installModularOperation = new InstallModularOperation(this.provisioningSession, this.metaModelReader);
        this.updateModularOperation = new UpdateModularOperation(this.provisioningSession, this.metaModelReader);
        this.uninstallModularOperation = new UninstallModularOperation(this.provisioningSession, this.metaModelReader);
        this.updateChecker = new UpdateChecker(iProvisioningAgent, this.profileRegistry, this.planner);
    }

    public Collection<ModularObject> getMetaModelFromRepository(Collection<URI> uris, IProgressMonitor progressMonitor) throws ProvisionException, OperationCanceledException {
        return this.metaModelReader.readMetamodelfromUri(uris, this.provisioningAgent, progressMonitor);
    }

    public IStatus install(ModularOperationStatus modularOperationStatus, IProgressMonitor progressMonitor) {
        String symbolicName = ModularInstallerActivator.getContext().getBundle().getSymbolicName();
        ProfileChangeOperation operation = modularOperationStatus.getExecutableOperation();
        if (operation != null && operation instanceof InstallOperation) {
            InstallOperation changeOperation = (InstallOperation)operation;
            try {
                this.installModularOperation.executeOperation((ProfileChangeOperation)changeOperation, progressMonitor);
                return new Status(0, symbolicName, "");
            }
            catch (OperationCanceledException e) {
                return new Status(8, symbolicName, e.getMessage());
            }
        }
        return new Status(4, symbolicName, ModularMessages.ModularInstallerServiceImplementation_EmptyOrNullInstallOperation);
    }

    public IStatus update(ModularOperationStatus modularOperationStatus, IProgressMonitor progressMonitor) {
        String symbolicName = ModularInstallerActivator.getContext().getBundle().getSymbolicName();
        ProfileChangeOperation operation = modularOperationStatus.getExecutableOperation();
        if (operation != null && operation instanceof UpdateOperation) {
            UpdateOperation changeOperation = (UpdateOperation)operation;
            try {
                this.updateModularOperation.executeOperation((ProfileChangeOperation)changeOperation, progressMonitor);
                return new Status(0, symbolicName, "");
            }
            catch (OperationCanceledException e) {
                return new Status(8, symbolicName, e.getMessage());
            }
        }
        return new Status(4, symbolicName, ModularMessages.ModularInstallerServiceImplementation_EmptyOrNullInstallOperation);
    }

    public Collection<URI> getAllAvailableRepository(IProgressMonitor monitor) {
        return this.metaModelReader.getEnabledRepositories(monitor);
    }

    public Collection<ModularObject> getInstalledUnit(IProgressMonitor progressMonitor) {
        return this.metaModelReader.getInstalledUnit(progressMonitor);
    }

    public ModularOperationStatus getResolutionStatusForInstall(Collection<ModularObject> modularObjects, IProgressMonitor progressMonitor) {
        ModularOperationStatusImpl resolutionStatus = this.installModularOperation.getResolutionStatus(modularObjects, progressMonitor);
        if (resolutionStatus.getStatus().getSeverity() == 4) {
            ModularInstallerActivator.getDefault().log((IStatus)resolutionStatus.getStatus());
        }
        return resolutionStatus;
    }

    public ModularOperationStatus getResolutionStatusForUpdate(Collection<ModularObject> modularObjects, IProgressMonitor progressMonitor) {
        ModularOperationStatusImpl resolutionStatus = this.updateModularOperation.getResolutionStatus(modularObjects, progressMonitor);
        if (resolutionStatus.getStatus().getSeverity() == 4) {
            ModularInstallerActivator.getDefault().log((IStatus)resolutionStatus.getStatus());
        }
        return resolutionStatus;
    }

    public IProfileRegistry getProfileRegistry() {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.provisioningSession.getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
        return profileRegistry;
    }

    public Collection<ModularPack> checkForUpdate(Collection<URI> uris, IProgressMonitor progressMonitor) throws ProvisionException, OperationCanceledException {
        return this.updateChecker.checkForUpdate(uris, progressMonitor);
    }

    public ModularOperationStatus getResolutionStatusForUninstall(Collection<ModularObject> modularObjects, IProgressMonitor progressMonitor) {
        ModularOperationStatusImpl resolutionStatus = this.uninstallModularOperation.getResolutionStatus(modularObjects, progressMonitor);
        if (resolutionStatus.getStatus().getSeverity() == 4) {
            ModularInstallerActivator.getDefault().log((IStatus)resolutionStatus.getStatus());
        }
        return resolutionStatus;
    }
}

