/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.debugger;

import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class DeviceDebuggerRegistryImplementation
extends BaseRegistry
implements DeviceDebuggerRegistry {
    private final Map<String, Collection<DeviceDebuggerDescriptor>> device2deviceDebuggerDescriptors = new HashMap<String, Collection<DeviceDebuggerDescriptor>>();
    private final Map<String, Collection<DeviceDebuggerDescriptor>> debugger2deviceDebuggerDescriptors = new HashMap<String, Collection<DeviceDebuggerDescriptor>>();

    @Override
    public List<DeviceDebuggerDescriptor> getDeviceDebuggerDescriptorsByDebuggerId(String debuggerId) {
        return this.getReferenceDescriptorsByTargetId(debuggerId, this.debugger2deviceDebuggerDescriptors, DeviceDebuggerDescriptor.class);
    }

    @Override
    public List<DeviceDebuggerDescriptor> getDeviceDebuggerDescriptorsByDeviceId(String deviceId) {
        return this.getReferenceDescriptorsBySourceId(deviceId, this.device2deviceDebuggerDescriptors, DeviceDebuggerDescriptor.class);
    }

    @Override
    public void addDeviceDebuggerDescriptor(DeviceDebuggerDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.device2deviceDebuggerDescriptors, this.debugger2deviceDebuggerDescriptors, DeviceDebuggerDescriptor.class);
    }

    @Override
    public void removeDeviceDebuggerDescriptor(DeviceDebuggerDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.device2deviceDebuggerDescriptors, this.debugger2deviceDebuggerDescriptors, DeviceDebuggerDescriptor.class);
    }

    @Override
    public List<DeviceDebuggerDescriptor> getDeviceDebuggerDescriptors(String deviceId) {
        ArrayList<DeviceDebuggerDescriptor> result = new ArrayList<DeviceDebuggerDescriptor>();
        Collection<DeviceDebuggerDescriptor> descriptors = this.device2deviceDebuggerDescriptors.get(deviceId);
        if (descriptors != null) {
            result.addAll(descriptors);
        }
        return result;
    }
}

