/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.ui;

import com.freescale.system.browser.internal.SystemBrowserActivator;
import com.freescale.system.browser.internal.ui.SystemContributor;
import com.freescale.system.browser.internal.ui.tabbed.ITabbedPage;
import com.freescale.system.browser.internal.ui.tabbed.ITabbedPageContributor;
import com.freescale.system.browser.internal.ui.tabbed.TabbedDefaultPage;
import com.freescale.system.browser.internal.ui.tabbed.TabbedSheetPage;
import com.freescale.system.browser.model.OSAwarenessData;
import com.freescale.system.browser.ui.CWExceptionLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.part.ViewPart;

public class TabbedSystemView
extends ViewPart
implements DsfSession.SessionEndedListener {
    private PageBook fBook = null;
    private static volatile TabbedSystemView sInstance;
    private PageRec fDefaultPageRec = null;
    private Object createPageLock = new Object();
    private List<PageRec> fPageRecs = new ArrayList<PageRec>();
    private ArrayList<IPropertyChangeListener> fPropertyListeners = new ArrayList();
    private Map<ITabbedPageContributor, PageRec> fMapContributorToRec = new HashMap<ITabbedPageContributor, PageRec>();
    private PageRec fActiveRec = null;
    private Map<String, OSAwarenessData> fSessionDataCache = new HashMap<String, OSAwarenessData>();
    private IPropertyChangeListener actionBarPropListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.ui.internal.actionHandlers".equals(event.getProperty()) && TabbedSystemView.this.fActiveRec != null && event.getSource() == ((TabbedSystemView)TabbedSystemView.this).fActiveRec.subActionBars) {
                TabbedSystemView.this.refreshGlobalActionHandlers();
            }
        }
    };
    private IDebugContextListener fDebugContextListener;
    private Object m_session;

    public static TabbedSystemView getInstance() {
        if (sInstance == null) {
            sInstance = new TabbedSystemView();
        }
        return sInstance;
    }

    public void createPartControl(Composite parent) {
        this.fBook = new PageBook(parent, 0);
        TabbedDefaultPage defaultPage = new TabbedDefaultPage();
        this.providePageSite(defaultPage);
        defaultPage.createControl((Composite)this.fBook);
        this.fDefaultPageRec = new PageRec(null, defaultPage);
        this.preparePage(this.fDefaultPageRec);
        this.setupContextListener();
    }

    private void activate(IRunControl.IExecutionDMContext newContext) {
        DsfSession newSession = null;
        OSAwarenessData newSessionData = null;
        boolean isChanged = false;
        if (newContext != null) {
            newSession = DsfSession.getSession((String)newContext.getSessionId());
        }
        if (newSession != null) {
            newSessionData = this.fSessionDataCache.get(newSession.getId());
            if (newSessionData == null) {
                newSessionData = new OSAwarenessData(newContext);
                this.fSessionDataCache.put(newSession.getId(), newSessionData);
                isChanged = true;
            }
        } else {
            this.fSessionDataCache.clear();
            newSessionData = new OSAwarenessData(null);
            isChanged = true;
        }
        if (!isChanged) {
            return;
        }
        if (this.fActiveRec != null && this.fActiveRec.page instanceof ITabbedPage) {
            ((ITabbedPage)this.fActiveRec.page).setPageInput(newSessionData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageRec getOrCreatePageRec(ITabbedPage page) {
        if (page.equals(this.fDefaultPageRec.page)) {
            return this.fDefaultPageRec;
        }
        Object object = this.createPageLock;
        synchronized (object) {
            PageRec rec = this.getPageRec(page);
            if (rec == null) {
                rec = this.createPage(page.getContributor());
            }
            return rec;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!this.fPropertyListeners.contains(listener)) {
            this.fPropertyListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fPropertyListeners.remove(listener);
    }

    public void setFocus() {
        if (this.fBook != null && !this.fBook.isDisposed()) {
            this.fBook.setFocus();
        }
        if (this.fActiveRec != null) {
            this.fActiveRec.page.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        IDebugContextManager contextManager = DebugUITools.getDebugContextManager();
        IDebugContextService contextService = contextManager.getContextService(this.getSite().getWorkbenchWindow());
        contextService.removeDebugContextListener(this.fDebugContextListener);
        this.activate(null);
        DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this);
        this.fActiveRec = null;
        if (this.fDefaultPageRec != null) {
            this.fDefaultPageRec.page.dispose();
            this.fDefaultPageRec.page = null;
            this.fDefaultPageRec = null;
        }
        if (this.fPageRecs != null) {
            for (PageRec pageRec : this.fPageRecs) {
                this.disposePage(pageRec);
            }
            this.fPageRecs.clear();
            this.fPageRecs = null;
        }
        this.fPropertyListeners = null;
        super.dispose();
    }

    protected void providePageSite(IPageBookViewPage page) {
        try {
            page.init((IPageSite)new PageSite(this.getViewSite()));
        }
        catch (PartInitException exc) {
            CWExceptionLogger.log((Exception)((Object)exc));
        }
    }

    protected void showPageRec(PageRec pageRec) {
        if (this.fActiveRec == pageRec) {
            return;
        }
        if (this.fActiveRec != null) {
            this.fActiveRec.subActionBars.deactivate();
        }
        this.fActiveRec = pageRec;
        Control pageControl = this.fActiveRec.page.getControl();
        if (pageControl != null && !pageControl.isDisposed()) {
            this.fBook.showPage(pageControl);
            this.fActiveRec.subActionBars.activate();
            this.refreshGlobalActionHandlers();
            this.getViewSite().getActionBars().updateActionBars();
        }
    }

    protected void doDestroyPage(ITabbedPageContributor part, PageRec rec) {
        ((ITabbedPage)rec.page).dispose();
        rec.page = null;
        rec.dispose();
    }

    protected PageBook getPageBook() {
        return this.fBook;
    }

    protected PageRec getPageRec(ITabbedPageContributor contributor) {
        return this.fMapContributorToRec.get(contributor);
    }

    protected PageRec getPageRec(IPageBookViewPage page) {
        for (PageRec rec : this.fPageRecs) {
            if (!rec.page.equals(page)) continue;
            return rec;
        }
        return null;
    }

    private PageRec createPage(ITabbedPageContributor part) {
        PageRec rec = null;
        ITabbedPage page = part.getTabbedSheetPage();
        if (page != null) {
            this.providePageSite(page);
            page.createControl((Composite)this.getPageBook());
            rec = new PageRec(part, page);
            this.preparePage(rec);
            this.fPageRecs.add(rec);
            this.fMapContributorToRec.put(part, rec);
            List clone = (List)((ArrayList)this.fPageRecs).clone();
            this.informListeners(this.fPropertyListeners, clone);
        } else {
            CWExceptionLogger.logAssert(false, "ITabbedPageContributor didn't provide a TabbedPage.");
        }
        return rec;
    }

    private void preparePage(PageRec rec) {
        IPageSite site = null;
        if (this.getPageRec(rec.page) == null) {
            site = rec.page.getSite();
            if (site == null) {
                site = new PageSite(this.getViewSite());
            }
            rec.subActionBars = (SubActionBars)site.getActionBars();
            rec.subActionBars.addPropertyChangeListener(this.actionBarPropListener);
            rec.page.setActionBars((IActionBars)rec.subActionBars);
        } else {
            site = rec.page.getSite();
            rec.subActionBars = (SubActionBars)site.getActionBars();
        }
    }

    private void disposePage(PageRec rec) {
        Control control;
        this.fMapContributorToRec.remove(rec.part);
        if (rec.subActionBars != null) {
            rec.subActionBars.removePropertyChangeListener(this.actionBarPropListener);
            rec.subActionBars.dispose();
            rec.subActionBars = null;
        }
        if ((control = rec.page.getControl()) != null && !control.isDisposed()) {
            control.dispose();
        }
        ((PageSite)rec.page.getSite()).deactivate();
        this.doDestroyPage(rec.part, rec);
    }

    private void informListeners(List<IPropertyChangeListener> listeners, Object obj) {
        for (IPropertyChangeListener listener : listeners) {
            listener.propertyChange(new PropertyChangeEvent((Object)this, "NewPageInstantiated", null, obj));
        }
    }

    private void refreshGlobalActionHandlers() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.clearGlobalActionHandlers();
        Map newActionHandlers = this.fActiveRec.subActionBars.getGlobalActionHandlers();
        if (newActionHandlers != null) {
            Set keys = newActionHandlers.entrySet();
            for (Map.Entry entry : keys) {
                bars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
    }

    private void chooseCurrentPage(ILaunch launch) {
        PageRec pagerec = null;
        if (launch != null) {
            SystemBrowserActivator.log(1, "chooseCurrentPage =>" + launch.toString());
            ILaunchConfiguration launchConfig = launch.getLaunchConfiguration();
            try {
                SystemContributor systemContributor = null;
                String osContributorId = launchConfig.getAttribute("com.freescale.s32ds.debug.ka.osplugin", "my_os");
                if (osContributorId != null && !osContributorId.equals(OSAwarenessData.getNoneValue())) {
                    String systemContributorID = osContributorId;
                    systemContributor = SystemContributor.getSystemContributor(systemContributorID);
                } else {
                    String debuggerId = launchConfig.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "be.be.be");
                    if (debuggerId != null) {
                        systemContributor = SystemContributor.getSystemContributorForDebugger(debuggerId);
                    } else {
                        CWExceptionLogger.logAssert(false, "Woah. This should definitely never, ever happen.");
                    }
                }
                if (systemContributor != null) {
                    Set<Map.Entry<ITabbedPageContributor, PageRec>> set = this.fMapContributorToRec.entrySet();
                    for (Map.Entry<ITabbedPageContributor, PageRec> entry : set) {
                        if (!entry.getKey().getContributorId().equals(systemContributor.getId())) continue;
                        pagerec = entry.getValue();
                    }
                    if (pagerec == null) {
                        TabbedSheetPage newPage = new TabbedSheetPage(systemContributor);
                        pagerec = this.getOrCreatePageRec(newPage);
                    }
                }
            }
            catch (CoreException e) {
                CWExceptionLogger.log((Exception)((Object)e));
            }
        }
        if (pagerec == null) {
            pagerec = this.fDefaultPageRec;
        }
        this.showPageRec(pagerec);
    }

    private void setupContextListener() {
        IDebugContextManager contextManager = DebugUITools.getDebugContextManager();
        IDebugContextService contextService = contextManager.getContextService(this.getSite().getWorkbenchWindow());
        this.fDebugContextListener = new IDebugContextListener(){

            public void debugContextChanged(DebugContextEvent event) {
                if ((event.getFlags() & 1) != 0) {
                    ISelection s = event.getContext();
                    TabbedSystemView.this.setDebugContext(s);
                }
            }
        };
        contextService.addDebugContextListener(this.fDebugContextListener);
        this.setDebugContext(contextService.getActiveContext());
    }

    private void setDebugContext(ISelection selection) {
        IStructuredSelection ss;
        IRunControl.IExecutionDMContext context = null;
        if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            Object element = ss.getFirstElement();
            SystemBrowserActivator.log(1, "setDebugContext with =>" + element.getClass());
            this.getLaunchContext(element);
            context = this.getExecutionDMContext(element);
            if (context != null && this.m_session == null) {
                ILaunch launch = (ILaunch)context.getAdapter(ILaunch.class);
                this.getLaunchContext(launch);
            }
        }
        this.activate(context);
    }

    private void getLaunchContext(Object element) {
        if (element instanceof GdbLaunch) {
            GdbLaunch launch = (GdbLaunch)element;
            if (launch.isTerminated()) {
                this.setDebugSession(null);
            } else {
                DsfSession session = launch.getSession();
                if (session != null && this.setDebugSession(session.getId())) {
                    this.chooseCurrentPage((ILaunch)launch);
                }
            }
        }
    }

    private IRunControl.IExecutionDMContext getExecutionDMContext(Object obj) {
        IAdaptable context;
        IDMContext idmContext;
        if (obj instanceof IAdaptable && (idmContext = (IDMContext)(context = (IAdaptable)obj).getAdapter(IDMContext.class)) != null) {
            return (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)idmContext, IRunControl.IExecutionDMContext.class);
        }
        return null;
    }

    public void sessionEnded(DsfSession arg0) {
        this.setDebugSession(null);
    }

    private boolean setDebugSession(String sessionId) {
        boolean changed = false;
        if (this.m_session != null && !this.m_session.equals(sessionId)) {
            this.m_session = null;
            changed = true;
        }
        if (this.m_session == null && sessionId != null) {
            this.m_session = sessionId;
            changed = true;
        }
        return changed;
    }

    protected static class PageRec {
        public ITabbedPageContributor part;
        public IPageBookViewPage page;
        public SubActionBars subActionBars;

        public PageRec(ITabbedPageContributor part, IPageBookViewPage page) {
            this.part = part;
            this.page = page;
        }

        public void dispose() {
            this.part = null;
            this.page = null;
        }
    }
}

