/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui.builtintab.tasks;

import com.freescale.system.browser.internal.Messages;
import com.freescale.system.browser.internal.ui.SimpleTableDataDescriptor;
import com.freescale.system.browser.internal.ui.Tab;
import com.freescale.system.browser.internal.ui.TabDescriptor;
import com.freescale.system.browser.internal.ui.builtintab.tasks.TasksSection;
import com.freescale.system.browser.internal.ui.tabbed.ISectionDescriptor;
import com.freescale.system.browser.model.ISimpleTableDataProvider;
import com.freescale.system.browser.ui.CWExceptionLogger;
import com.freescale.system.browser.ui.ISection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TasksTabDescriptor
extends TabDescriptor {
    private static final String ELEM_COLUMN = "systemTabTasksColumn";
    private static final String ATT_TILE = "title";
    private static final String ATT_ICON = "icon";
    private static final String ATT_DATAID = "dataID";
    private static final String ATT_WIDTH = "width";
    private static final String ATT_IS_NUMERIC = "isNumeric";
    private static final String ATT_COLUMN_LABEL = "label";
    private static final String ATT_NAME_COL_SHOW = "columnNameShow";
    private static final String ATT_NAME_COL_WIDTH = "columnNameWidth";
    private static final String ATT_STATUS_COL_SHOW = "columnStatusShow";
    private static final String ATT_ID_COL_SHOW = "columnIDShow";
    private static final String ATT_ID_COL_HEX = "columnIDHex";
    protected static final String BUILTIN_COLUMN_DATAID_NAME = "name";
    protected static final String BUILTIN_COLUMN_DATAID_ID = "id";
    protected static final String BUILTIN_COLUMN_DATAID_STATUS = "status";
    private final List<Column> fCustomColumns = new LinkedList<Column>();
    private String fShowNameColumn;
    private String fWidthNameColumn;
    private String fShowStateColumn;
    private String fShowIdColumn;
    private String fHexIdColumn;
    private ISimpleTableDataProvider fTaskData;

    public TasksTabDescriptor(IConfigurationElement configurationElement) {
        super(configurationElement);
        IConfigurationElement[] children;
        String iconstr;
        this.fTitle = configurationElement.getAttribute(ATT_TILE);
        if (this.fTitle == null) {
            this.fTitle = Messages.TasksTab_Default_Label;
        }
        if ((iconstr = configurationElement.getAttribute(ATT_ICON)) != null) {
            this.fIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)configurationElement.getDeclaringExtension().getNamespaceIdentifier(), (String)iconstr);
        }
        this.fShowNameColumn = configurationElement.getAttribute(ATT_NAME_COL_SHOW);
        this.fWidthNameColumn = configurationElement.getAttribute(ATT_NAME_COL_WIDTH);
        this.fShowStateColumn = configurationElement.getAttribute(ATT_STATUS_COL_SHOW);
        this.fShowIdColumn = configurationElement.getAttribute(ATT_ID_COL_SHOW);
        this.fHexIdColumn = configurationElement.getAttribute(ATT_ID_COL_HEX);
        IConfigurationElement[] iConfigurationElementArray = children = configurationElement.getChildren(ELEM_COLUMN);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String label = child.getAttribute(ATT_COLUMN_LABEL);
            String dataId = child.getAttribute(ATT_DATAID);
            int width = 200;
            boolean isNumeric = false;
            String value = child.getAttribute(ATT_WIDTH);
            if (value != null) {
                try {
                    width = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    CWExceptionLogger.logAssert(false, "System Browser: invalid custom column width specification");
                }
            }
            if ((value = child.getAttribute(ATT_IS_NUMERIC)) != null) {
                try {
                    isNumeric = Boolean.parseBoolean(value);
                }
                catch (NumberFormatException numberFormatException) {
                    CWExceptionLogger.logAssert(false, "System Browser: invalid custom column isNumeric specification");
                }
            }
            if (label != null && dataId != null) {
                this.fCustomColumns.add(new Column(label, dataId, width, isNumeric));
            }
            ++n2;
        }
    }

    @Override
    protected Tab createTabEx() {
        TasksSection.Options options = new TasksSection.Options();
        if (this.fShowNameColumn != null) {
            boolean bl = options.hideNameColumn = !Boolean.parseBoolean(this.fShowNameColumn);
        }
        if (this.fShowStateColumn != null) {
            boolean bl = options.hideStatusColumn = !Boolean.parseBoolean(this.fShowStateColumn);
        }
        if (this.fWidthNameColumn != null) {
            try {
                options.nameColumnWidth = Integer.parseInt(this.fWidthNameColumn);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.fShowIdColumn != null) {
            boolean bl = options.hideIdColumn = !Boolean.parseBoolean(this.fShowIdColumn);
        }
        if (this.fHexIdColumn != null) {
            options.hexIdColumn = Boolean.parseBoolean(this.fHexIdColumn);
        }
        if (this.fTaskData != null) {
            options.taskData = this.fTaskData;
        }
        TasksSection tasksSection = new TasksSection(this.fCustomColumns.toArray(new Column[this.fCustomColumns.size()]), options);
        ArrayList<ISection> taskList = new ArrayList<ISection>();
        taskList.add(tasksSection);
        Tab tab = new Tab(this, taskList);
        return tab;
    }

    @Override
    public String getId() {
        return this.getClass().toString();
    }

    @Override
    protected void addSectionDescriptor(ISectionDescriptor section) {
        if (section instanceof SimpleTableDataDescriptor) {
            this.fTaskData = ((SimpleTableDataDescriptor)section).createDataProvider();
        }
    }

    public final ISimpleTableDataProvider getTableDataObject() {
        return this.fTaskData;
    }

    public static class Column {
        public final String label;
        public final String dataId;
        public final int width;
        public final boolean builtIn;
        public final boolean isNumeric;

        public Column(String label, String dataId, int width, boolean isNumeric) {
            this.label = label;
            this.dataId = dataId;
            this.width = width;
            this.isNumeric = isNumeric;
            this.builtIn = false;
        }

        public Column(String label, String dataId, int width) {
            this.label = label;
            this.dataId = dataId;
            this.width = width;
            this.builtIn = true;
            this.isNumeric = false;
        }
    }
}

