/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui;

import com.freescale.system.browser.ui.TabbedWidgetFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TabbedTitle
extends Composite {
    private static final String BLANK = "";
    private CLabel fLabel;
    private Image fImage = null;
    private String fText = null;
    private int fMarginWidth = 4;
    private int fMarginHeight = 4;
    private TabbedWidgetFactory fFactory;

    public TabbedTitle(Composite parent, TabbedWidgetFactory factory) {
        super(parent, 524288);
        this.fFactory = factory;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TabbedTitle.this.fImage == null && (TabbedTitle.this.fText == null || TabbedTitle.this.fText.equals(TabbedTitle.BLANK))) {
                    TabbedTitle.this.fLabel.setVisible(false);
                } else {
                    TabbedTitle.this.fLabel.setVisible(true);
                    TabbedTitle.this.drawTitleBackground(e);
                }
            }
        });
        factory.getColors().initializeSectionToolBarColors();
        this.setBackground(factory.getColors().getBackground());
        this.setForeground(factory.getColors().getForeground());
        FormLayout layout = new FormLayout();
        layout.marginWidth = 11;
        layout.marginHeight = 5;
        this.setLayout((Layout)layout);
        this.fLabel = factory.createCLabel(this, BLANK);
        this.fLabel.setBackground(new Color[]{factory.getColors().getColor("org.eclipse.ui.forms.TB_BG"), factory.getColors().getColor("org.eclipse.ui.forms.TB_BG")}, new int[]{100}, true);
        this.fLabel.setFont(JFaceResources.getBannerFont());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.fLabel.setLayoutData((Object)data);
    }

    public void setTitle(String text, Image image) {
        this.fText = text;
        this.fImage = image;
        if (text != null) {
            this.fLabel.setText(text);
        } else {
            this.fLabel.setText(BLANK);
        }
        this.fLabel.setImage(image);
        this.redraw();
    }

    public int getHeight() {
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(this.getFont());
        Point point = gc.textExtent(BLANK);
        ++point.x;
        int textOrImageHeight = Math.max(point.x, 16);
        gc.dispose();
        shell.dispose();
        return textOrImageHeight + 8;
    }

    protected void drawTitleBackground(PaintEvent e) {
        Color bg = this.fFactory.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        Color gbg = this.fFactory.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        Color border = this.fFactory.getColors().getColor("org.eclipse.ui.forms.TB_BORDER");
        Rectangle bounds = this.getClientArea();
        Point labelSize = null;
        if (this.fLabel != null) {
            labelSize = this.fLabel.computeSize(-1, -1, true);
        }
        int tvmargin = 4;
        int theight = this.getHeight();
        if (labelSize != null) {
            theight = Math.max(theight, labelSize.y);
        }
        int midpoint = (theight += tvmargin + tvmargin) * 66 / 100;
        int rem = theight - midpoint;
        GC gc = e.gc;
        gc.setForeground(bg);
        gc.setBackground(gbg);
        gc.fillGradientRectangle(this.fMarginWidth, this.fMarginHeight, bounds.width - 1 - this.fMarginWidth - this.fMarginWidth, midpoint - 1, true);
        gc.setForeground(gbg);
        gc.setBackground(this.getBackground());
        gc.fillGradientRectangle(this.fMarginWidth, this.fMarginHeight + midpoint - 1, bounds.width - 1 - this.fMarginWidth - this.fMarginWidth, rem - 1, true);
        gc.setForeground(border);
        gc.drawLine(this.fMarginWidth, this.fMarginHeight + 2, this.fMarginWidth, this.fMarginHeight + theight - 1);
        gc.drawLine(this.fMarginWidth, this.fMarginHeight + 2, this.fMarginWidth + 2, this.fMarginHeight);
        gc.drawLine(this.fMarginWidth + 2, this.fMarginHeight, bounds.width - this.fMarginWidth - 3, this.fMarginHeight);
        gc.drawLine(bounds.width - this.fMarginWidth - 3, this.fMarginHeight, bounds.width - this.fMarginWidth - 1, this.fMarginHeight + 2);
        gc.drawLine(bounds.width - this.fMarginWidth - 1, this.fMarginHeight + 2, bounds.width - this.fMarginWidth - 1, this.fMarginHeight + theight - 1);
    }
}

