/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui;

import com.freescale.system.browser.internal.Messages;
import com.freescale.system.browser.internal.ui.tabbed.ITabDescriptor;
import com.freescale.system.browser.ui.TabbedWidgetFactory;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class TabbedList
extends Composite {
    private static final ListElement[] ELEMENTS_EMPTY = new ListElement[0];
    private static final int ANTICIPATE_ICON = 32;
    protected static final int INDENT = 7;
    private boolean fFocus = false;
    private ListElement[] fElements;
    private int fSelectedElementIndex = -1;
    private int fTopVisibleIndex = -1;
    private int fBottomVisibleIndex = -1;
    private TopNavigationElement fTopNavigationElement;
    private BottomNavigationElement fBottomNavigationElement;
    private int fWidestLabelIndex = -1;
    private int fTabsThatFitInComposite = -1;
    private Color fHoverBackground;
    private Color fDefaultBackground;
    private Color fDefaultForeground;
    private Color fActiveBackground;
    private Color fBorder;
    private Color fDarkShadow;
    private Color fTextColor;
    private TabbedWidgetFactory fFactory;

    public TabbedList(Composite parent, TabbedWidgetFactory factory) {
        super(parent, 524288);
        this.fFactory = factory;
        this.removeAll();
        this.setLayout((Layout)new FormLayout());
        this.initColours();
        this.initAccessible();
        this.fTopNavigationElement = new TopNavigationElement(this);
        this.fBottomNavigationElement = new BottomNavigationElement(this);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TabbedList.this.fFocus = true;
                int i = TabbedList.this.getSelectionIndex();
                if (i >= 0) {
                    TabbedList.this.fElements[i].redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                TabbedList.this.fFocus = false;
                int i = TabbedList.this.getSelectionIndex();
                if (i >= 0) {
                    TabbedList.this.fElements[i].redraw();
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TabbedList.this.computeTopAndBottomTab();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 32 || e.detail == 64) {
                    int nMax = TabbedList.this.fElements.length - 1;
                    int nCurrent = TabbedList.this.getSelectionIndex();
                    if (e.detail == 32) {
                        --nCurrent;
                        nCurrent = Math.max(0, nCurrent);
                    } else if (e.detail == 64) {
                        ++nCurrent;
                        nCurrent = Math.min(nCurrent, nMax);
                    }
                    TabbedList.this.select(nCurrent, true);
                    TabbedList.this.redraw();
                } else {
                    e.doit = true;
                }
            }
        });
    }

    protected void computeTabsThatFitInComposite() {
        float size = this.getSize().y - 22;
        float tabHeight = this.getTabHeight();
        this.fTabsThatFitInComposite = Math.round(size / tabHeight);
        if (this.fTabsThatFitInComposite <= 0) {
            this.fTabsThatFitInComposite = 1;
        }
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.fElements.length) {
            return this.fElements[index];
        }
        return null;
    }

    public int getSelectionIndex() {
        return this.fSelectedElementIndex;
    }

    public void removeAll() {
        if (this.fElements != null) {
            int i = 0;
            while (i < this.fElements.length) {
                this.fElements[i].dispose();
                ++i;
            }
        }
        this.fElements = ELEMENTS_EMPTY;
        this.fSelectedElementIndex = -1;
        this.fWidestLabelIndex = -1;
        this.fTopVisibleIndex = -1;
        this.fBottomVisibleIndex = -1;
    }

    public void setElements(ITabDescriptor[] children) {
        if (this.fElements != ELEMENTS_EMPTY) {
            this.removeAll();
        }
        this.fElements = new ListElement[children.length];
        if (children.length == 0) {
            this.fWidestLabelIndex = -1;
        } else {
            this.fWidestLabelIndex = 0;
            int i = 0;
            while (i < children.length) {
                this.fElements[i] = new ListElement(this, children[i], i);
                this.fElements[i].setVisible(false);
                this.fElements[i].setLayoutData(null);
                if (i != this.fWidestLabelIndex) {
                    String label = children[i].getLabel();
                    if (this.getTextDimension((String)label).x > this.getTextDimension((String)children[this.fWidestLabelIndex].getLabel()).x) {
                        this.fWidestLabelIndex = i;
                    }
                }
                ++i;
            }
        }
        this.computeTopAndBottomTab();
    }

    public void select(int index, boolean reveal) {
        if (this.fSelectedElementIndex == index) {
            return;
        }
        if (index >= 0 && index < this.fElements.length) {
            int lastSelected = this.fSelectedElementIndex;
            this.fElements[index].setSelected(true);
            this.fSelectedElementIndex = index;
            if (lastSelected >= 0) {
                this.fElements[lastSelected].setSelected(false);
                if (this.fSelectedElementIndex != this.fElements.length - 1) {
                    this.fElements[this.fSelectedElementIndex + 1].setSelected(false);
                }
            }
            this.fTopNavigationElement.redraw();
            this.fBottomNavigationElement.redraw();
            if (this.fSelectedElementIndex < this.fTopVisibleIndex || this.fSelectedElementIndex > this.fBottomVisibleIndex) {
                this.computeTopAndBottomTab();
            }
        }
        this.notifyListeners(13, new Event());
    }

    public void deselectAll() {
        if (this.getSelectionIndex() >= 0) {
            this.fElements[this.getSelectionIndex()].setSelected(false);
            this.fSelectedElementIndex = -1;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point result = super.computeSize(hHint, wHint, changed);
        if (this.fWidestLabelIndex < 0) {
            result.x = this.getTextDimension((String)Messages.TabbedList_properties_No_tabs_to_show).x + 7;
        } else {
            int width = this.getTextDimension((String)this.fElements[this.fWidestLabelIndex].getText()).x;
            result.x = width + 32;
        }
        return result;
    }

    public void dispose() {
        this.fHoverBackground.dispose();
        this.fDefaultBackground.dispose();
        this.fDefaultForeground.dispose();
        this.fActiveBackground.dispose();
        this.fBorder.dispose();
        this.fDarkShadow.dispose();
        this.fTextColor.dispose();
        super.dispose();
    }

    private int getIndex(ListElement element) {
        return element.fIndex;
    }

    private Point getTextDimension(String text) {
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(this.getFont());
        Point point = gc.textExtent(text);
        ++point.x;
        gc.dispose();
        shell.dispose();
        return point;
    }

    private void initColours() {
        this.fDefaultBackground = Display.getCurrent().getSystemColor(22);
        RGB rgb = this.fDefaultBackground.getRGB();
        rgb.blue = Math.min(255, Math.round((float)rgb.blue * 1.05f));
        rgb.red = Math.min(255, Math.round((float)rgb.red * 1.05f));
        rgb.green = Math.min(255, Math.round((float)rgb.green * 1.05f));
        this.fHoverBackground = this.fFactory.getColors().createColor("TabbedList.hoverBackground", rgb);
        this.fDefaultForeground = Display.getCurrent().getSystemColor(21);
        this.fActiveBackground = Display.getCurrent().getSystemColor(25);
        this.fBorder = Display.getCurrent().getSystemColor(18);
        this.fDarkShadow = Display.getCurrent().getSystemColor(17);
        this.fTextColor = Display.getCurrent().getSystemColor(21);
    }

    private int getTabHeight() {
        int tabHeight = this.getTextDimension((String)"").y + 7;
        if (this.fTabsThatFitInComposite == 1) {
            int ret = this.getBounds().height - 20;
            return ret > tabHeight ? tabHeight : (ret < 5 ? 5 : ret);
        }
        return tabHeight;
    }

    private boolean isDownScrollRequired() {
        return this.fElements.length > this.fTabsThatFitInComposite && this.fBottomVisibleIndex != this.fElements.length - 1;
    }

    private boolean isUpScrollRequired() {
        return this.fElements.length > this.fTabsThatFitInComposite && this.fTopVisibleIndex != 0;
    }

    private void computeTopAndBottomTab() {
        this.computeTabsThatFitInComposite();
        if (this.fElements.length == 0) {
            this.fTopVisibleIndex = 0;
            this.fBottomVisibleIndex = 0;
        } else if (this.fTabsThatFitInComposite >= this.fElements.length) {
            this.fTopVisibleIndex = 0;
            this.fBottomVisibleIndex = this.fElements.length - 1;
        } else if (this.getSelectionIndex() < 0) {
            this.fTopVisibleIndex = 0;
            this.fBottomVisibleIndex = this.fTabsThatFitInComposite - 1;
        } else if (this.getSelectionIndex() + this.fTabsThatFitInComposite > this.fElements.length) {
            this.fBottomVisibleIndex = this.fElements.length - 1;
            this.fTopVisibleIndex = this.fBottomVisibleIndex - this.fTabsThatFitInComposite + 1;
        } else {
            this.fTopVisibleIndex = this.fSelectedElementIndex;
            this.fBottomVisibleIndex = this.fSelectedElementIndex + this.fTabsThatFitInComposite - 1;
        }
        this.layoutTabs();
    }

    private void layoutTabs() {
        FormData formData;
        if (this.fTabsThatFitInComposite < 0 || this.fElements.length == 0) {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = this.getTabHeight();
            this.fTopNavigationElement.setLayoutData(formData);
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.fTopNavigationElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            this.fBottomNavigationElement.setLayoutData(formData);
        } else {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = 10;
            this.fTopNavigationElement.setLayoutData(formData);
            Canvas nextElement = this.fTopNavigationElement;
            int i = 0;
            while (i < this.fElements.length) {
                if (i < this.fTopVisibleIndex || i > this.fBottomVisibleIndex) {
                    this.fElements[i].setLayoutData(null);
                    this.fElements[i].setVisible(false);
                } else {
                    formData = new FormData();
                    formData.height = this.getTabHeight();
                    formData.left = new FormAttachment(0, 0);
                    formData.right = new FormAttachment(100, 0);
                    formData.top = new FormAttachment((Control)nextElement, 0);
                    nextElement = this.fElements[i];
                    this.fElements[i].setLayoutData(formData);
                    this.fElements[i].setVisible(true);
                }
                ++i;
            }
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)nextElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.height = 10;
            this.fBottomNavigationElement.setLayoutData(formData);
        }
        Composite grandparent = this.getParent().getParent();
        grandparent.layout(true);
        this.layout(true);
    }

    private void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (TabbedList.this.getSelectionIndex() >= 0) {
                    e.result = TabbedList.this.fElements[TabbedList.this.getSelectionIndex()].getText();
                }
            }

            public void getHelp(AccessibleEvent e) {
                if (TabbedList.this.getSelectionIndex() >= 0) {
                    e.result = TabbedList.this.fElements[TabbedList.this.getSelectionIndex()].getText();
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = TabbedList.this.toControl(new Point(e.x, e.y));
                e.childID = TabbedList.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                if (TabbedList.this.getSelectionIndex() >= 0) {
                    Rectangle location = TabbedList.this.fElements[TabbedList.this.getSelectionIndex()].getBounds();
                    Point pt = TabbedList.this.toDisplay(new Point(location.x, location.y));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 37;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x300006;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TabbedList.this.isFocusControl()) {
                    accessible.setFocus(-1);
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    public class BottomNavigationElement
    extends Canvas {
        public BottomNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    BottomNavigationElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (TabbedList.this.isDownScrollRequired()) {
                        TabbedList tabbedList = TabbedList.this;
                        tabbedList.fTopVisibleIndex = tabbedList.fTopVisibleIndex + 1;
                        if (TabbedList.this.fBottomVisibleIndex != TabbedList.this.fElements.length - 1) {
                            TabbedList tabbedList2 = TabbedList.this;
                            tabbedList2.fBottomVisibleIndex = tabbedList2.fBottomVisibleIndex + 1;
                        }
                        TabbedList.this.layoutTabs();
                        TabbedList.this.fTopNavigationElement.redraw();
                        TabbedList.this.fBottomNavigationElement.redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(TabbedList.this.fDefaultBackground);
            e.gc.setForeground(TabbedList.this.fDefaultForeground);
            Rectangle bounds = this.getBounds();
            if (TabbedList.this.fElements.length != 0) {
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(TabbedList.this.fBorder);
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
                if (TabbedList.this.getSelectionIndex() >= 0 && TabbedList.this.fElements.length != 0 && TabbedList.this.getSelectionIndex() == TabbedList.this.fElements.length - 1) {
                    e.gc.drawLine(4, 0, bounds.width - 1, 0);
                } else {
                    e.gc.drawLine(2, 0, bounds.width - 1, 0);
                }
            } else {
                e.gc.setBackground(TabbedList.this.fDefaultBackground);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            }
            if (TabbedList.this.isDownScrollRequired()) {
                e.gc.setForeground(TabbedList.this.fDarkShadow);
                int middle = bounds.width / 2;
                int bottom = bounds.height - 2;
                e.gc.drawLine(middle + 1, bottom, middle + 5, bottom - 4);
                e.gc.drawLine(middle, bottom, middle - 4, bottom - 4);
                e.gc.drawLine(middle - 4, bottom - 5, middle + 5, bottom - 5);
                e.gc.setForeground(TabbedList.this.fActiveBackground);
                e.gc.drawLine(middle, bottom - 1, middle + 1, bottom - 1);
                e.gc.drawLine(middle - 1, bottom - 2, middle + 2, bottom - 2);
                e.gc.drawLine(middle - 2, bottom - 3, middle + 3, bottom - 3);
                e.gc.drawLine(middle - 3, bottom - 4, middle + 4, bottom - 4);
            }
        }
    }

    public class ListElement
    extends Canvas {
        private ITabDescriptor fTab;
        private int fIndex;
        private boolean fSelected;
        private boolean fHover;

        public ListElement(Composite parent, ITabDescriptor tab, int index) {
            super(parent, 524288);
            this.fTab = tab;
            this.fHover = false;
            this.fSelected = false;
            this.fIndex = index;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    ListElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (!ListElement.this.fSelected) {
                        TabbedList.this.select(TabbedList.this.getIndex(ListElement.this), true);
                    }
                }
            });
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (!ListElement.this.fHover) {
                        ListElement.this.fHover = true;
                        ListElement.this.redraw();
                    }
                }
            });
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    ListElement.this.fHover = false;
                    ListElement.this.redraw();
                }
            });
        }

        public void setSelected(boolean selected) {
            this.fSelected = selected;
            this.redraw();
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(TabbedList.this.fDefaultBackground);
            e.gc.setForeground(TabbedList.this.fDefaultForeground);
            Rectangle bounds = this.getBounds();
            e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            if (this.fSelected) {
                e.gc.setBackground(TabbedList.this.fActiveBackground);
            } else if (this.fHover) {
                e.gc.setBackground(TabbedList.this.fHoverBackground);
            } else {
                e.gc.setBackground(TabbedList.this.fDefaultBackground);
            }
            if (this.fSelected) {
                e.gc.fillRectangle(4, 0, bounds.width, bounds.height);
                e.gc.fillRectangle(3, 1, 3, bounds.height);
            } else if (this.fHover) {
                e.gc.fillRectangle(2, 0, bounds.width - 4, bounds.height);
            }
            if (this.fSelected) {
                e.gc.setForeground(TabbedList.this.fBorder);
                e.gc.drawLine(4, 0, bounds.width - 1, 0);
                e.gc.drawPoint(3, 1);
                e.gc.drawPoint(3, bounds.height - 1);
                e.gc.drawLine(2, 2, 2, bounds.height - 2);
            } else {
                e.gc.setForeground(TabbedList.this.fBorder);
                if (TabbedList.this.getSelectionIndex() >= 0 && TabbedList.this.getSelectionIndex() + 1 == this.fIndex) {
                    e.gc.drawLine(4, 0, bounds.width - 1, 0);
                } else {
                    e.gc.drawLine(2, 0, bounds.width - 3, 0);
                }
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            }
            int textIndent = 7;
            FontMetrics fm = e.gc.getFontMetrics();
            int height = fm.getHeight();
            int textMiddle = (bounds.height - height) / 2;
            if (this.fSelected && this.fTab.getImage() != null) {
                e.gc.drawImage(this.fTab.getImage().createImage(), textIndent - 2, textMiddle);
                textIndent = textIndent + 16 + 2;
            } else if (this.fTab.isIndented()) {
                e.gc.drawRectangle(20, textMiddle + 6, 1, 1);
                textIndent = textIndent + 16 + 4;
            }
            e.gc.setForeground(TabbedList.this.fTextColor);
            e.gc.drawText(this.fTab.getLabel(), textIndent, textMiddle);
            if (((TabbedList)this.getParent()).fFocus && this.fSelected) {
                Point point = e.gc.textExtent(this.fTab.getLabel());
                e.gc.drawLine(textIndent, bounds.height - 4, textIndent + point.x, bounds.height - 4);
            }
        }

        public String getText() {
            return this.fTab.getLabel();
        }

        public String toString() {
            return this.fTab.getLabel();
        }
    }

    public class TopNavigationElement
    extends Canvas {
        public TopNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    TopNavigationElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (TabbedList.this.isUpScrollRequired()) {
                        TabbedList tabbedList = TabbedList.this;
                        tabbedList.fBottomVisibleIndex = tabbedList.fBottomVisibleIndex - 1;
                        if (TabbedList.this.fTopVisibleIndex != 0) {
                            TabbedList tabbedList2 = TabbedList.this;
                            tabbedList2.fTopVisibleIndex = tabbedList2.fTopVisibleIndex - 1;
                        }
                        TabbedList.this.layoutTabs();
                        TabbedList.this.fTopNavigationElement.redraw();
                        TabbedList.this.fBottomNavigationElement.redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(TabbedList.this.fDefaultBackground);
            e.gc.setForeground(TabbedList.this.fDefaultForeground);
            Rectangle bounds = this.getBounds();
            if (TabbedList.this.fElements.length != 0) {
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(TabbedList.this.fBorder);
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            } else {
                e.gc.setBackground(TabbedList.this.fDefaultBackground);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                int textIndent = 7;
                FontMetrics fm = e.gc.getFontMetrics();
                int height = fm.getHeight();
                int textMiddle = (bounds.height - height) / 2;
                e.gc.setForeground(TabbedList.this.fTextColor);
                e.gc.drawText(Messages.TabbedList_properties_No_tabs_to_show, textIndent, textMiddle);
            }
            if (TabbedList.this.isUpScrollRequired()) {
                e.gc.setForeground(TabbedList.this.fDarkShadow);
                int middle = bounds.width / 2;
                e.gc.drawLine(middle + 1, 3, middle + 5, 7);
                e.gc.drawLine(middle, 3, middle - 4, 7);
                e.gc.drawLine(middle - 4, 8, middle + 5, 8);
                e.gc.setForeground(TabbedList.this.fActiveBackground);
                e.gc.drawLine(middle, 4, middle + 1, 4);
                e.gc.drawLine(middle - 1, 5, middle + 2, 5);
                e.gc.drawLine(middle - 2, 6, middle + 3, 6);
                e.gc.drawLine(middle - 3, 7, middle + 4, 7);
            }
        }
    }
}

