/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui;

import com.freescale.system.browser.internal.Messages;
import com.freescale.system.browser.internal.SystemBrowserActivator;
import com.freescale.system.browser.internal.ui.Tab;
import com.freescale.system.browser.internal.ui.tabbed.ISectionDescriptor;
import com.freescale.system.browser.internal.ui.tabbed.ITabDescriptor;
import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class TabDescriptor
implements ITabDescriptor {
    protected static final String ATT_TITLE = "title";
    protected static final String ATT_IMAGE = "image";
    protected static final String ATT_INDENTED = "indented";
    protected static final String ATT_AFTER_TAB = "afterTab";
    protected static final String TOP = "top";
    protected boolean fIndented;
    protected String fAfterTab;
    protected boolean fSelected;
    protected String fTitle;
    protected ImageDescriptor fIcon;
    private static final String TAB_ERROR = Messages.TabDescriptor_Tab_error;

    protected TabDescriptor(IConfigurationElement configurationElement) {
        this.fAfterTab = configurationElement.getAttribute(ATT_AFTER_TAB);
        String indentedString = configurationElement.getAttribute(ATT_INDENTED);
        this.fIndented = indentedString != null && indentedString.equals("true");
        this.fAfterTab = configurationElement.getAttribute(ATT_AFTER_TAB);
        if (this.fAfterTab == null) {
            this.fAfterTab = TOP;
        }
    }

    @Override
    public boolean isIndented() {
        return this.fIndented;
    }

    @Override
    public boolean isSelected() {
        return this.fSelected;
    }

    @Override
    public abstract String getId();

    @Override
    public ImageDescriptor getImage() {
        return this.fIcon;
    }

    @Override
    public String getLabel() {
        return this.fTitle;
    }

    @Override
    public final Tab createTab() {
        return this.createTabEx();
    }

    protected abstract Tab createTabEx();

    protected void handleTabError(IConfigurationElement configurationElement, CoreException exception) {
        String pluginId = configurationElement.getDeclaringExtension().getNamespaceIdentifier();
        String message = MessageFormat.format((String)TAB_ERROR, (Object[])new Object[]{pluginId});
        Status status = new Status(4, pluginId, 0, message, (Throwable)exception);
        SystemBrowserActivator.getPlugin().getLog().log((IStatus)status);
    }

    @Override
    public boolean showForInput(Object input) {
        return input != null;
    }

    protected abstract void addSectionDescriptor(ISectionDescriptor var1);
}

