/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui;

import com.freescale.system.browser.internal.Messages;
import com.freescale.system.browser.internal.SystemBrowserActivator;
import com.freescale.system.browser.internal.ui.tabbed.ISectionDescriptor;
import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class SectionDescriptor
implements ISectionDescriptor {
    private static final String SECTION_ERROR = Messages.SectionDescriptor_Section_error;
    protected static final String ATT_ID = "id";
    protected static final String ATT_TARGET_TAB = "tab";
    private final String fId;
    private String fTargetTab;
    private final IConfigurationElement fConfigurationElement;

    protected SectionDescriptor(IConfigurationElement configurationElement) {
        this.fId = configurationElement.getAttribute(ATT_ID);
        this.fTargetTab = configurationElement.getAttribute(ATT_TARGET_TAB);
        this.fConfigurationElement = configurationElement;
    }

    protected SectionDescriptor(IConfigurationElement configurationElement, String string) {
        this(configurationElement);
        this.fTargetTab = string;
    }

    public final IConfigurationElement getConfigurationElement() {
        return this.fConfigurationElement;
    }

    @Override
    public final String getId() {
        return this.fId;
    }

    @Override
    public final String getTargetTab() {
        return this.fTargetTab;
    }

    protected void handleSectionError(CoreException exception) {
        String pluginId = this.getConfigurationElement().getDeclaringExtension().getNamespaceIdentifier();
        String message = MessageFormat.format((String)SECTION_ERROR, (Object[])new Object[]{pluginId});
        Status status = new Status(4, pluginId, 0, message, (Throwable)exception);
        SystemBrowserActivator.log((IStatus)status);
    }
}

