/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal;

import com.freescale.system.browser.internal.SystemBrowserActivator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;

public class DSFSessionTrail {
    private final String m_sessionId;
    private final List<Object> m_sessionListeners;
    private final DsfServicesTracker m_servicesTracker;

    public DSFSessionTrail(String sessionId) {
        this.m_sessionId = sessionId;
        this.m_sessionListeners = new ArrayList<Object>();
        this.m_servicesTracker = new DsfServicesTracker(SystemBrowserActivator.getBundleContext(), this.m_sessionId);
    }

    public void dispose() {
        if (this.m_sessionId != null) {
            this.removeAllServiceEventListeners();
        }
        if (this.m_servicesTracker != null) {
            this.m_servicesTracker.dispose();
        }
    }

    public String getSessionID() {
        return this.m_sessionId;
    }

    public void addServiceEventListener(Object listener) {
        final Object listener_f = listener;
        final DsfSession session_f = this.getDsfSession();
        if (session_f != null) {
            try {
                session_f.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        session_f.addServiceEventListener(listener_f, null);
                        DSFSessionTrail.this.m_sessionListeners.add(listener_f);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                SystemBrowserActivator.log(2, e.getMessage());
            }
        }
    }

    public void removeServiceEventListener(Object listener) {
        final Object listener_f = listener;
        final DsfSession session_f = this.getDsfSession();
        if (session_f != null) {
            try {
                session_f.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        if (DSFSessionTrail.this.m_sessionListeners != null) {
                            session_f.removeServiceEventListener(listener_f);
                            DSFSessionTrail.this.m_sessionListeners.remove(listener_f);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                SystemBrowserActivator.log(2, e.getMessage());
            }
        }
    }

    public void removeAllServiceEventListeners() {
        final DsfSession session_f = this.getDsfSession();
        if (session_f != null) {
            try {
                session_f.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        if (DSFSessionTrail.this.m_sessionListeners != null) {
                            for (Object listener : DSFSessionTrail.this.m_sessionListeners) {
                                session_f.removeServiceEventListener(listener);
                            }
                            DSFSessionTrail.this.m_sessionListeners.clear();
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                SystemBrowserActivator.log(2, e.getMessage());
            }
        }
    }

    protected DsfSession getDsfSession() {
        return DsfSession.getSession((String)this.m_sessionId);
    }
}

