/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.kernel.registry;

import com.nxp.s32ds.ext.emf.ecore.external.ExternalUriProtocol;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelSource;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.internal.registry.Apex2KernelRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Apex2KernelRegistryManager {
    public static final Apex2KernelRegistryManager INSTANCE = new Apex2KernelRegistryManager();
    private Apex2KernelRegistry registry;

    private Apex2KernelRegistryManager() {
    }

    public void setRegistry(Apex2KernelRegistry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("Argument registry is null");
        }
        if (this.registry != null) {
            throw new IllegalArgumentException("Registry has already been set");
        }
        this.registry = registry;
    }

    public String getArchetype(ApuKernelInfo info) {
        for (Map.Entry<String, List<ApuKernelInfo>> entry : this.registry.getCachedRegistry().entrySet()) {
            if (!entry.getValue().contains(info)) continue;
            return entry.getKey();
        }
        return "";
    }

    public String getArchetypeByComparingURIs(ApuKernelInfo info) {
        for (Map.Entry<String, List<ApuKernelInfo>> entry : this.registry.getCachedRegistry().entrySet()) {
            if (!entry.getValue().stream().anyMatch(ki -> EcoreUtil.getURI((EObject)ki).equals(EcoreUtil.getURI((EObject)info)))) continue;
            return entry.getKey();
        }
        return "";
    }

    public String getArchetype(ApuKernelSource source) {
        Set<Map.Entry<String, List<ApuKernelInfo>>> entrySet = this.registry.getCachedRegistry().entrySet();
        for (Map.Entry<String, List<ApuKernelInfo>> entry : this.registry.getCachedRegistry().entrySet()) {
            if (Collections.disjoint(source.getKernelInfos(), (Collection)entry.getValue())) continue;
            return entry.getKey();
        }
        for (Map.Entry<String, List<ApuKernelInfo>> entry : entrySet) {
            List cachedKernelsUris;
            List sourceKernelsUris = source.getKernelInfos().stream().map(ki -> ExternalUriProtocol.resolve((URI)ki.eResource().getURI())).collect(Collectors.toList());
            if (Collections.disjoint(sourceKernelsUris, cachedKernelsUris = entry.getValue().stream().map(ki -> ExternalUriProtocol.resolve((URI)ki.eResource().getURI())).collect(Collectors.toList()))) continue;
            return entry.getKey();
        }
        return "";
    }

    public List<ApuKernelInfo> getAllArchetypesKernelInfos() {
        return this.registry.getCachedRegistry().values().stream().flatMap(infos -> infos.stream()).collect(Collectors.toList());
    }

    public List<ApuKernelInfo> getKernelInfosByArchetype(String archetypeId) {
        return this.registry.getCachedRegistry().get(archetypeId);
    }

    public void rescan() {
        this.registry.scan();
    }

    public void rescanArchetypes(Collection<String> archetypes) {
        this.registry.scanArchetypes(archetypes);
    }
}

