/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.kernel.internal.registry.component;

import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.internal.registry.Apex2KernelRegistryActivator;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.internal.registry.Messages;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.internal.registry.component.Apex2KernelBlockRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class Apex2KernelBlocksSavingJob
extends Job {
    private Map<String, List<ApuKernelInfo>> archetype2KernelInfos = new HashMap<String, List<ApuKernelInfo>>();

    public Apex2KernelBlocksSavingJob(Map<String, List<ApuKernelInfo>> archetype2KernelInfos) {
        super(Messages.Apex2KernelBlocksSavingJob_saving_to_block_registry_title);
        this.archetype2KernelInfos = archetype2KernelInfos;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            MultiStatus multi = Apex2KernelRegistryActivator.getDefault().createMultiStatus();
            this.archetype2KernelInfos.entrySet().forEach(entry -> {
                String archetypeId = (String)entry.getKey();
                List kernelInfos = (List)entry.getValue();
                try {
                    try {
                        monitor.beginTask(NLS.bind((String)Messages.Apex2KernelBlocksSavingJob_saving_to_block_registry, (Object)archetypeId), -1);
                        Apex2KernelBlockRegistry.removeBlocksByArchetype(archetypeId);
                        kernelInfos.forEach(ki -> Apex2KernelBlockRegistry.putToBlockRegistry(ki, archetypeId));
                    }
                    catch (Throwable t) {
                        String message = NLS.bind((String)Messages.Apex2KernelBlocksSavingJob_error_saving_to_block_registry, (Object)archetypeId);
                        multi.add(Apex2KernelRegistryActivator.getDefault().createError(message, t));
                        monitor.worked(1);
                    }
                }
                finally {
                    monitor.worked(1);
                }
            });
            MultiStatus multiStatus = multi;
            return multiStatus;
        }
        finally {
            monitor.done();
        }
    }
}

