/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.kernel.internal.registry;

import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.internal.registry.Apex2KernelRegistryActivator;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.internal.registry.Messages;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.loaders.Apex2KernelLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class Apex2KernelScannerJob
extends Job {
    private final List<Apex2KernelLoader> loaders;
    private Map<String, List<ApuKernelInfo>> archetype2Kernels = new HashMap<String, List<ApuKernelInfo>>();

    public Apex2KernelScannerJob(Collection<Apex2KernelLoader> loaders) {
        super(Messages.Apex2KernelScannerJob_name);
        this.loaders = new LinkedList<Apex2KernelLoader>(loaders);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            MultiStatus multi = Apex2KernelRegistryActivator.getDefault().createMultiStatus();
            monitor.beginTask(Messages.Apex2KernelScannerJob_name, this.loaders.size());
            for (Apex2KernelLoader loader : this.loaders) {
                SubMonitor subProgressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                try {
                    try {
                        List kernelInfos = loader.load();
                        this.archetype2Kernels.put(loader.getArchetypeId(), kernelInfos);
                    }
                    catch (Throwable t) {
                        String message = NLS.bind((String)Messages.Apex2KernelScannerJob_error_loading, (Object)loader.getArchetypeId());
                        multi.add(Apex2KernelRegistryActivator.getDefault().createError(message, t));
                        subProgressMonitor.worked(1);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    subProgressMonitor.worked(1);
                    throw throwable;
                }
                subProgressMonitor.worked(1);
            }
            MultiStatus multiStatus = multi;
            return multiStatus;
        }
        finally {
            monitor.done();
        }
    }

    public Map<String, List<ApuKernelInfo>> getArchetypeToKernelsMap() {
        return this.archetype2Kernels;
    }
}

