/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.kernel.internal.registry;

import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.internal.registry.component.Apex2KernelBlocksSavingJob;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.loaders.Apex2KernelLoader;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.loaders.Apex2KernelLoaders;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.EMFPlugin;

public class Apex2KernelRegistry {
    private Map<String, List<ApuKernelInfo>> archetype2Kernels = new HashMap<String, List<ApuKernelInfo>>();

    public Apex2KernelRegistry() {
        this.scan();
    }

    public void scan() {
        List<String> archetypes = Apex2KernelLoaders.INSTANCE.getLoaders().stream().map(loader -> loader.getArchetypeId()).collect(Collectors.toList());
        this.scanArchetypes(archetypes);
    }

    public void scanArchetypes(Collection<String> archetypes) {
        List<Apex2KernelLoader> loaders = Apex2KernelLoaders.INSTANCE.getLoaders().stream().filter(loader -> archetypes.contains(loader.getArchetypeId())).collect(Collectors.toList());
        if (loaders.isEmpty()) {
            return;
        }
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.scanUI(loaders);
        } else {
            this.scanStandalone(loaders);
        }
    }

    private void scanUI(List<Apex2KernelLoader> loaders) {
        this.scanStandalone(loaders);
        Apex2KernelBlocksSavingJob blocksSavingJob = new Apex2KernelBlocksSavingJob(this.getArchetype2Kernels());
        blocksSavingJob.setSystem(true);
        blocksSavingJob.schedule();
    }

    private void scanStandalone(List<Apex2KernelLoader> loaders) {
        loaders.forEach(l -> this.archetype2Kernels.put(l.getArchetypeId(), l.load()));
    }

    public Map<String, List<ApuKernelInfo>> getCachedRegistry() {
        return this.getArchetype2Kernels();
    }

    public Map<String, List<ApuKernelInfo>> getArchetype2Kernels() {
        return this.archetype2Kernels;
    }

    public void setArchetype2Kernels(Map<String, List<ApuKernelInfo>> archetype2Kernels) {
        this.archetype2Kernels = archetype2Kernels;
    }
}

