/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.vpt.internal.program.ui.wizards;

import com.nxp.s32ds.ext.ide.core.IProjectParticipant;
import com.nxp.s32ds.gte.apuprogram.design.ApuProgramDescriptor;
import com.nxp.s32ds.gte.apuprogram.design.ApuProgramRepresenter;
import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import com.nxp.s32ds.vgt.ide.core.VgtRepresenter;
import com.nxp.s32ds.vgt.ide.ui.operations.VgtProjectConfigurator;
import com.nxp.s32ds.vgt.ide.ui.operations.VgtProjectCreationRunnable;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkingSet;

public class ProgramWizardParticipant
implements IProjectParticipant,
VgtProjectConfigurator {
    public static final String APU_CO_PROCESSOR_GRAPH_ENABLE = "apuCoProcessorEnable";
    public static final String ICP_DESIGN = "icp_design";
    private static final String GRAPH_FOLDER_TEMPLATE = "graphs";
    private static final String SOURCE_FOLDER_TEMPLATE = "A53_gen/src";
    private static final String KERNEL_FOLDER_TEMPLATE = "APU_kernels";

    public String getId() {
        return ICP_DESIGN;
    }

    protected String getGraphEnableParameterId() {
        return APU_CO_PROCESSOR_GRAPH_ENABLE;
    }

    protected ApuProgramRepresenter getRepresenter() {
        return new ApuProgramRepresenter();
    }

    public IStatus configure(VgtDescriptor descriptor, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public boolean isApplicable(Map<String, String> context) {
        String graphEnableParameterId = this.getGraphEnableParameterId();
        String graphEnabled = context.get(graphEnableParameterId);
        return Boolean.parseBoolean(graphEnabled);
    }

    public IWorkspaceRunnable participate(Map<String, String> context, IProject target) {
        String targetName = target.getName();
        String projectName = String.valueOf(targetName) + '_' + this.getId();
        IProject projectHandle = target.getWorkspace().getRoot().getProject(projectName);
        ApuProgramRepresenter representer = this.getRepresenter();
        ApuProgramDescriptor descriptor = representer.createApuProgramDescriptor();
        descriptor.hostProjectChanged(targetName);
        descriptor.setGraphFolderName(GRAPH_FOLDER_TEMPLATE);
        descriptor.setSourceFolderName(SOURCE_FOLDER_TEMPLATE);
        descriptor.setKernelFolderName(KERNEL_FOLDER_TEMPLATE);
        URI targetLocation = target.getLocationURI();
        URI projectLocation = null;
        if (targetLocation != null) {
            projectLocation = URIUtil.toURI((String)(String.valueOf(URIUtil.toDecodedString((URI)targetLocation)) + '_' + this.getId()), (boolean)false);
        }
        IWorkingSet[] workingSets = null;
        VgtProjectCreationRunnable operation = new VgtProjectCreationRunnable((VgtRepresenter)representer, (VgtDescriptor)descriptor, projectHandle, target, projectLocation, workingSets);
        operation.addConfigurator((VgtProjectConfigurator)this);
        return operation;
    }
}

