/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.vpt.internal.program.ui.representers;

import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apuprogram.ApuPointerInlet;
import com.nxp.s32ds.gte.apuprogram.ApuPointerOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProcessInput;
import com.nxp.s32ds.gte.apuprogram.ApuProcessOutput;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuProgramFactory;
import com.nxp.s32ds.gte.apuprogram.ApuProgramInlet;
import com.nxp.s32ds.gte.apuprogram.ApuPrograms;
import com.nxp.s32ds.gte.apuprogram.design.ApuProgramRepresenter;
import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class CreateProgramFromGraphRepresenter
extends ApuProgramRepresenter {
    List<ApuGraph> graphs;

    public CreateProgramFromGraphRepresenter(List<ApuGraph> graphs) {
        this.graphs = graphs;
    }

    public EObject createSemanticModel(VgtDescriptor descriptor) {
        ApuProgram program = (ApuProgram)super.createSemanticModel(descriptor);
        for (ApuGraph apuGraph : this.graphs) {
            ApuPrograms.addProcess((ApuProgram)program, (ApuGraph)apuGraph);
        }
        EList processes = ApuPrograms.getProcesses((ApuProgram)program);
        for (ApuProcess process : processes) {
            this.processInputs(program, (List<ApuProcessInput>)process.getProcessInputs());
            this.processOutputs(program, (List<ApuProcessOutput>)process.getProcessOutputs());
        }
        return program;
    }

    private void processInputs(ApuProgram program, List<ApuProcessInput> inputs) {
        for (ApuProcessInput input : inputs) {
            ApuPointerInlet inlet = ApuProgramFactory.eINSTANCE.createApuPointerInlet();
            inlet.setProgram(program);
            inlet.setName(String.valueOf(input.getProcess().getName()) + "_" + input.getName() + "_inlet");
            input.setProgramInlet((ApuProgramInlet)inlet);
        }
    }

    private void processOutputs(ApuProgram program, List<ApuProcessOutput> outputs) {
        for (ApuProcessOutput output : outputs) {
            ApuPointerOutlet outlet = ApuProgramFactory.eINSTANCE.createApuPointerOutlet();
            outlet.setProgram(program);
            outlet.setName(String.valueOf(output.getProcess().getName()) + "_" + output.getName() + "_outlet");
            outlet.setProcessOutput(output);
        }
    }
}

